/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.api.CharsetAwareVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1451", name="Copyright and license headers should be defined", priority=Priority.BLOCKER)
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="5min")
public class FileHeaderCheck
extends SquidCheck<LexerlessGrammar>
implements CharsetAwareVisitor {
    private static final String DEFAULT_HEADER_FORMAT = "";
    @RuleProperty(key="headerFormat", type="TEXT", description="Expected copyright and license header", defaultValue="")
    public String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    public boolean isRegularExpression = false;
    private Charset charset;
    private String[] expectedLines;
    private Pattern regularExpression = null;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void init() {
        if (this.isRegularExpression) {
            this.regularExpression = this.headerFormat.endsWith("\n") || this.headerFormat.endsWith("\r") ? Pattern.compile(this.headerFormat) : Pattern.compile(this.headerFormat + "(\r|\r\n|\n)");
        } else {
            this.expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
        }
    }

    public void visitFile(AstNode astNode) {
        boolean hasHeader;
        File file = this.getContext().getFile();
        boolean bl = hasHeader = this.isRegularExpression ? this.matchesRegularExpression(file) : this.matchesPlainTextHeader(file);
        if (!hasHeader) {
            this.getContext().createFileViolation((CodeCheck)this, "Add or update the header of this file.", new Object[0]);
        }
    }

    @VisibleForTesting
    protected boolean matchesRegularExpression(File file) {
        String content;
        try {
            content = Files.toString((File)file, (Charset)this.charset);
        }
        catch (IOException e) {
            throw new IllegalStateException(FileHeaderCheck.exceptionMessage(file), e);
        }
        Matcher matcher = this.regularExpression.matcher(content);
        if (matcher.find()) {
            return matcher.start() == 0;
        }
        return false;
    }

    @VisibleForTesting
    protected boolean matchesPlainTextHeader(File file) {
        List lines;
        try {
            lines = Files.readLines((File)file, (Charset)this.charset);
        }
        catch (IOException e) {
            throw new IllegalStateException(FileHeaderCheck.exceptionMessage(file), e);
        }
        return FileHeaderCheck.matches(this.expectedLines, lines);
    }

    private static boolean matches(String[] expectedLines, List<String> lines) {
        boolean result;
        if (expectedLines.length <= lines.size()) {
            result = true;
            Iterator<String> it = lines.iterator();
            for (int i = 0; i < expectedLines.length; ++i) {
                String line = it.next();
                if (line.equals(expectedLines[i])) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }

    private static String exceptionMessage(File file) {
        return String.format("Unable to execute rule \"S1451\" for file %s", file.getName());
    }
}

