/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S107", name="Functions should not have too many parameters", tags={"brain-overload"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="20min")
public class FunctionWithTooManyParametersCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT = 7;
    @RuleProperty(key="max", description="Maximum authorized number of parameters", defaultValue="7")
    int max = 7;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.PARAMETERS});
    }

    public void visitNode(AstNode astNode) {
        int nbParameters = astNode.getChildren(new AstNodeType[]{FlexGrammar.PARAMETER, FlexGrammar.REST_PARAMETERS}).size();
        if (nbParameters > this.max) {
            this.getContext().createLineViolation((CodeCheck)this, "This function has {0,number,integer} parameters, which is greater than the {1,number,integer} authorized.", astNode, new Object[]{nbParameters, this.max});
        }
    }
}

