/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.grammar.GrammarRuleKey;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1952", name="Objects should not be instantiated inside a loop", tags={"performance"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class InstantiationInLoopCheck
extends SquidCheck<LexerlessGrammar> {
    private static final GrammarRuleKey[] ITERATION_NODES = new GrammarRuleKey[]{FlexGrammar.DO_STATEMENT, FlexGrammar.WHILE_STATEMENT, FlexGrammar.FOR_STATEMENT};
    private int loopLevel = 0;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.FULL_NEW_EXPR, FlexGrammar.SHORT_NEW_EXPR, FlexGrammar.OBJECT_INITIALISER});
        this.subscribeTo((AstNodeType[])ITERATION_NODES);
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.loopLevel = 0;
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])ITERATION_NODES)) {
            ++this.loopLevel;
        } else if (this.loopLevel > 0 && !InstantiationInLoopCheck.isNestedNewExpression(astNode)) {
            this.getContext().createLineViolation((CodeCheck)this, "Move the instantiation of this \"{0}\" outside the loop.", astNode, new Object[]{InstantiationInLoopCheck.getClassName(astNode)});
        }
    }

    private static boolean isNestedNewExpression(AstNode newExpression) {
        return newExpression.getParent().is(new AstNodeType[]{FlexGrammar.FULL_NEW_SUB_EXPR, FlexGrammar.SHORT_NEW_SUB_EXPR});
    }

    private static Object getClassName(AstNode astNode) {
        String currentTokenValue;
        if (astNode.is(new AstNodeType[]{FlexGrammar.OBJECT_INITIALISER})) {
            return "Object";
        }
        List tokens = astNode.getTokens();
        int nbToken = tokens.size();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < nbToken && !"[".equals(currentTokenValue = ((Token)tokens.get(i)).getValue()) && !"(".equals(currentTokenValue); ++i) {
            if ("new".equals(currentTokenValue)) continue;
            builder.append(currentTokenValue);
        }
        return builder.toString();
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is((AstNodeType[])ITERATION_NODES)) {
            --this.loopLevel;
        }
    }
}

