/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.io.Files;
import com.sonar.sslr.api.AstNode;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.api.CharsetAwareVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="LineLength", name="Lines should not be too long", tags={"convention"}, priority=Priority.MINOR)
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class LineLengthCheck
extends SquidCheck<LexerlessGrammar>
implements CharsetAwareVisitor {
    private static final int DEFAULT_MAXIMUM_LINE_LENHGTH = 80;
    private static final Logger LOG = LoggerFactory.getLogger(LineLengthCheck.class);
    private Charset charset;
    @RuleProperty(key="maximumLineLength", description="The maximum authorized line length.", defaultValue="80")
    public int maximumLineLength = 80;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void visitFile(@Nullable AstNode astNode) {
        List lines = Collections.emptyList();
        try {
            lines = Files.readLines((File)this.getContext().getFile(), (Charset)this.charset);
        }
        catch (IOException e) {
            LOG.error("Unable to execute rule \"LineLength\" for file {} because of error: {}", (Object)this.getContext().getFile().getName(), (Object)e);
        }
        for (int i = 0; i < lines.size(); ++i) {
            String line = (String)lines.get(i);
            if (line.length() <= this.maximumLineLength) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Split this {0} characters long line (which is greater than {1} authorized).", i + 1, new Object[]{line.length(), this.maximumLineLength});
        }
    }
}

