/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1821", name="\"switch\" statements should not be nested", tags={"pitfall"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="10min")
public class NestedSwitchCheck
extends SquidCheck<LexerlessGrammar> {
    private int switchLevel = 0;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.SWITCH_STATEMENT});
    }

    public void leaveFile(@Nullable AstNode astNode) {
        this.switchLevel = 0;
    }

    public void visitNode(AstNode astNode) {
        ++this.switchLevel;
        if (this.switchLevel > 1) {
            this.getContext().createLineViolation((CodeCheck)this, "Move this \"switch\" to a function or refactor the code to eliminate it.", astNode, new Object[0]);
        }
    }

    public void leaveNode(AstNode astNode) {
        --this.switchLevel;
    }
}

