/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1301", name="\"switch\" statements should have at least 3 \"case\" clauses", tags={"misra"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class NotEnoughCaseForSwitchCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int MINIMUM_CASE = 3;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.SWITCH_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        int nbCase = 0;
        for (AstNode caseElement : astNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_ELEMENT})) {
            nbCase += caseElement.getChildren(new AstNodeType[]{FlexGrammar.CASE_LABEL}).size();
        }
        if (nbCase < 3) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace this \"switch\" statement with \"if\" statements to increase readability.", astNode, new Object[0]);
        }
    }
}

