/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Function;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1470", name="Any class extending the Event class should override Event.clone()", tags={"bug"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class OverrideEventCloneFunctionCheck
extends SquidCheck<LexerlessGrammar> {
    private static final String EVENT_TYPE_NAME = "Event";

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void visitNode(AstNode astNode) {
        if (!OverrideEventCloneFunctionCheck.isExtendingEvent(astNode)) {
            return;
        }
        List classDirectives = astNode.getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK}).getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getChildren(new AstNodeType[]{FlexGrammar.DIRECTIVE});
        for (AstNode directive : classDirectives) {
            if (!OverrideEventCloneFunctionCheck.isOverridingFunction(directive) || !OverrideEventCloneFunctionCheck.isCloneFunction(directive)) continue;
            return;
        }
        this.getContext().createLineViolation((CodeCheck)this, "Make this class \"{0}\" override \"Event.clone()\" function.", astNode, new Object[]{astNode.getFirstChild(new AstNodeType[]{FlexGrammar.CLASS_NAME}).getFirstChild(new AstNodeType[]{FlexGrammar.CLASS_IDENTIFIERS}).getLastChild().getTokenValue()});
    }

    private static boolean isCloneFunction(AstNode directive) {
        AstNode functionDef = directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}).getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_DEF});
        String functionName = Function.getName(functionDef);
        return "clone".equals(functionName) && EVENT_TYPE_NAME.equals(OverrideEventCloneFunctionCheck.getResultType(functionDef));
    }

    private static String getResultType(AstNode functionDef) {
        AstNode resultType = functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_SIGNATURE}).getFirstChild(new AstNodeType[]{FlexGrammar.RESULT_TYPE});
        if (resultType != null && resultType.getFirstChild(new AstNodeType[]{FlexGrammar.TYPE_EXPR}) != null) {
            return resultType.getFirstChild(new AstNodeType[]{FlexGrammar.TYPE_EXPR}).getTokenValue();
        }
        return null;
    }

    private static boolean isExtendingEvent(AstNode classDef) {
        AstNode qualifiedId;
        AstNode inheritenceNode = classDef.getFirstChild(new AstNodeType[]{FlexGrammar.INHERITENCE});
        return inheritenceNode != null && inheritenceNode.getFirstChild(new AstNodeType[]{FlexKeyword.EXTENDS}) != null && (qualifiedId = inheritenceNode.getFirstChild(new AstNodeType[]{FlexGrammar.TYPE_EXPR}).getLastChild()).is(new AstNodeType[]{FlexGrammar.QUALIFIED_IDENTIFIER}) && EVENT_TYPE_NAME.equals(qualifiedId.getTokenValue());
    }

    private static boolean isOverridingFunction(AstNode directive) {
        return OverrideEventCloneFunctionCheck.isFunctionWithAttributes(directive) && OverrideEventCloneFunctionCheck.isOverriding(directive);
    }

    private static boolean isFunctionWithAttributes(AstNode directive) {
        return directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}) != null && directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}).getFirstChild().is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF}) && directive.getFirstChild(new AstNodeType[]{FlexGrammar.ATTRIBUTES}) != null;
    }

    private static boolean isOverriding(AstNode directive) {
        for (AstNode attribute : directive.getFirstChild(new AstNodeType[]{FlexGrammar.ATTRIBUTES}).getChildren()) {
            if (!attribute.getFirstChild().is(new AstNodeType[]{FlexGrammar.ATTRIBUTE_EXPR}) || attribute.getFirstChild().getNumberOfChildren() != 1 || !attribute.getFirstChild().getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER}).getTokenValue().equals(FlexKeyword.OVERRIDE.getValue())) continue;
            return true;
        }
        return false;
    }
}

