/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Iterables;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1151", name="\"switch case\" clauses should not have too many lines", tags={"brain-overload"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class TooManyLinesInCaseCheck
extends SquidCheck<LexerlessGrammar> {
    private static final int DEFAULT = 5;
    @RuleProperty(key="max", description="Maximum number of lines", defaultValue="5")
    int max = 5;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CASE_ELEMENT});
    }

    public void visitNode(AstNode astNode) {
        AstNode lastLabelNode = (AstNode)Iterables.getLast((Iterable)astNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_LABEL}));
        int lines = Math.max(astNode.getNextAstNode().getTokenLine() - lastLabelNode.getTokenLine(), 1);
        if (lines > this.max) {
            this.getContext().createLineViolation((CodeCheck)this, "Reduce this switch case number of lines from {0} to at most {1}, for example by extracting code into methods.", lastLabelNode, new Object[]{lines, this.max});
        }
    }
}

