/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Function;
import org.sonar.flex.checks.utils.Modifiers;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1144", name="Unused private function should be removed", tags={"unused"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedPrivateFunctionCheck
extends SquidCheck<LexerlessGrammar> {
    private Deque<ClassState> classStack = new ArrayDeque<ClassState>();
    private boolean inClass;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF, FlexGrammar.FUNCTION_DEF, FlexGrammar.QUALIFIED_IDENTIFIER});
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.classStack.clear();
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF})) {
            this.inClass = true;
            this.classStack.push(new ClassState(astNode));
        } else if (this.inClass && astNode.is(new AstNodeType[]{FlexGrammar.QUALIFIED_IDENTIFIER})) {
            this.classStack.peek().use(astNode);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF})) {
            this.reportUnusedPrivateFunction();
            this.classStack.pop();
            this.inClass = !this.classStack.isEmpty();
        }
    }

    private void reportUnusedPrivateFunction() {
        for (Map.Entry entry : this.classStack.peek().functions.entrySet()) {
            if (((PrivateFunction)entry.getValue()).usages != 0) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Remove the declaration of the unused '" + (String)entry.getKey() + "' function.", ((PrivateFunction)entry.getValue()).declaration, new Object[0]);
        }
    }

    private static class ClassState {
        private final Map<String, PrivateFunction> functions = Maps.newHashMap();

        public ClassState(AstNode classDef) {
            this.retrieveAllPrivateFunctions(classDef);
        }

        private void retrieveAllPrivateFunctions(AstNode classDef) {
            for (AstNode functionDef : Clazz.getFunctions(classDef)) {
                if (Function.isAccessor(functionDef) || !Modifiers.getModifiers(functionDef.getPreviousAstNode()).contains(FlexKeyword.PRIVATE) || Function.isEmptyConstructor(functionDef, Clazz.getName(classDef))) continue;
                AstNode identifierNode = functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_NAME}).getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER});
                this.functions.put(identifierNode.getTokenValue(), new PrivateFunction(identifierNode, 0));
            }
        }

        private void use(AstNode astNode) {
            PrivateFunction function = this.functions.get(astNode.getTokenValue());
            if (function != null) {
                ++function.usages;
                return;
            }
        }
    }

    static class PrivateFunction {
        final AstNode declaration;
        int usages;

        public PrivateFunction(AstNode declaration, int usages) {
            this.declaration = declaration;
            this.usages = usages;
        }
    }
}

