/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S101", name="Class names should comply with a naming convention", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class ClassNameCheck
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT = "^[A-Z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the class names against", defaultValue="^[A-Z][a-zA-Z0-9]*$")
    String format = "^[A-Z][a-zA-Z0-9]*$";

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
    }

    public void visitNode(AstNode astNode) {
        String classIdentifier = Clazz.getName(astNode);
        if (!this.pattern.matcher(classIdentifier).matches()) {
            this.getContext().createLineViolation((CodeCheck)this, "Rename this class name to match the regular expression {0}", astNode, new Object[]{this.format});
        }
    }
}

