/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1066", name="Collapsible \"if\" statements should be merged", priority=Priority.MAJOR, tags={"clumsy"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class CollapsibleIfStatementCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.IF_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        AstNode nestedCollapsibleIf;
        AstNode childtSatementNode;
        if (!CollapsibleIfStatementCheck.hasElseClause(astNode) && (childtSatementNode = astNode.getFirstChild(new AstNodeType[]{FlexGrammar.SUB_STATEMENT}).getFirstChild(new AstNodeType[]{FlexGrammar.STATEMENT})) != null && (nestedCollapsibleIf = CollapsibleIfStatementCheck.getNestedIfCollapsible(childtSatementNode.getFirstChild())) != null) {
            this.getContext().createLineViolation((CodeCheck)this, "Merge this if statement with the enclosing one.", nestedCollapsibleIf, new Object[0]);
        }
    }

    private static AstNode getNestedIfCollapsible(AstNode statementNode) {
        AstNode singleStatementChild;
        if (statementNode.is(new AstNodeType[]{FlexGrammar.IF_STATEMENT})) {
            return statementNode;
        }
        if (statementNode.is(new AstNodeType[]{FlexGrammar.BLOCK}) && statementNode.getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getChildren().size() == 1 && (singleStatementChild = statementNode.getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVE}).getFirstChild()).is(new AstNodeType[]{FlexGrammar.STATEMENT}) && singleStatementChild.getFirstChild().is(new AstNodeType[]{FlexGrammar.IF_STATEMENT})) {
            AstNode ifNode = singleStatementChild.getFirstChild();
            return !CollapsibleIfStatementCheck.hasElseClause(ifNode) ? ifNode : null;
        }
        return null;
    }

    private static boolean hasElseClause(AstNode astNode) {
        return astNode.hasDirectChildren(new AstNodeType[]{FlexKeyword.ELSE});
    }
}

