/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Function;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1467", name="Constructors should not dispatch events", priority=Priority.BLOCKER, tags={"bug"})
@ActivatedByDefault
@SqaleConstantRemediation(value="10min")
public class ConstructorCallsDispatchEventCheck
extends SquidCheck<LexerlessGrammar> {
    boolean isInClass;
    private Deque<ClassState> classStack = new ArrayDeque<ClassState>();

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF, FlexGrammar.FUNCTION_DEF, FlexGrammar.PRIMARY_EXPR});
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.classStack.clear();
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF})) {
            this.isInClass = true;
            String className = Clazz.getName(astNode);
            this.classStack.push(new ClassState(className));
        } else if (this.isConstructor(astNode)) {
            this.classStack.peek().isInConstructor = true;
        } else if (this.isCallToDispatchEventInConstructor(astNode)) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this event dispatch from the \"{0}\" constructor", astNode, new Object[]{this.classStack.peek().className});
        }
    }

    private boolean isConstructor(AstNode astNode) {
        return this.isInClass && astNode.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF}) && Function.isConstructor(astNode, this.classStack.peek().className);
    }

    private boolean isCallToDispatchEventInConstructor(AstNode astNode) {
        return this.isInClass && this.classStack.peek().isInConstructor && astNode.is(new AstNodeType[]{FlexGrammar.PRIMARY_EXPR}) && ConstructorCallsDispatchEventCheck.isCallToDispatchEvent(astNode);
    }

    private static boolean isCallToDispatchEvent(AstNode primaryExpr) {
        return "dispatchEvent".equals(primaryExpr.getTokenValue()) && primaryExpr.getNextAstNode().is(new AstNodeType[]{FlexGrammar.ARGUMENTS}) && primaryExpr.getNextAstNode().getFirstChild(new AstNodeType[]{FlexGrammar.LIST_EXPRESSION}) != null;
    }

    public void leaveNode(AstNode astNode) {
        if (this.isInClass && this.classStack.peek().isInConstructor && astNode.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF})) {
            this.classStack.peek().isInConstructor = false;
        } else if (this.isInClass && astNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF})) {
            this.classStack.pop();
            this.isInClass = !this.classStack.isEmpty();
        }
    }

    private static class ClassState {
        String className;
        boolean isInConstructor;

        public ClassState(String className) {
            this.className = className;
        }
    }
}

