/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Function;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1447", name="Constructor bodies should be as lightweight as possible", priority=Priority.MAJOR, tags={"performance"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class ConstructorNotLightweightCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void visitNode(AstNode astNode) {
        AstNode constructorDef = Clazz.getConstructor(astNode);
        if (constructorDef != null && ConstructorNotLightweightCheck.containsBranch(constructorDef)) {
            this.getContext().createLineViolation((CodeCheck)this, "Extract the content of this \"{0}\" constructor into a dedicated function", constructorDef, new Object[]{Function.getName(constructorDef)});
        }
    }

    private static boolean containsBranch(AstNode constructorDef) {
        AstNode blockNode = constructorDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK});
        if (blockNode != null) {
            for (AstNode directive : blockNode.getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getChildren()) {
                if (!ConstructorNotLightweightCheck.isBranch(directive)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isBranch(AstNode directive) {
        AstNode astNode = directive.getFirstChild();
        return astNode.is(new AstNodeType[]{FlexGrammar.STATEMENT}) && astNode.getFirstChild().is(new AstNodeType[]{FlexGrammar.IF_STATEMENT, FlexGrammar.SWITCH_STATEMENT, FlexGrammar.DO_STATEMENT, FlexGrammar.WHILE_STATEMENT, FlexGrammar.FOR_STATEMENT});
    }
}

