/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1445", name="Constructors should not have a \"void\" return type", priority=Priority.MINOR, tags={"confusing"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class ConstructorWithVoidReturnTypeCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void visitNode(AstNode astNode) {
        AstNode constructorDef = Clazz.getConstructor(astNode);
        if (constructorDef != null && ConstructorWithVoidReturnTypeCheck.hasVoidReturnType(constructorDef)) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove the \"void\" return type from this \"{0}\" constructor", constructorDef, new Object[]{astNode.getFirstChild(new AstNodeType[]{FlexGrammar.CLASS_NAME}).getFirstChild(new AstNodeType[]{FlexGrammar.CLASS_IDENTIFIERS}).getLastChild().getTokenValue()});
        }
    }

    private static boolean hasVoidReturnType(AstNode functionDef) {
        AstNode resultTypeNode = functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_SIGNATURE}).getFirstChild(new AstNodeType[]{FlexGrammar.RESULT_TYPE});
        return resultTypeNode != null && resultTypeNode.getFirstChild(new AstNodeType[]{FlexKeyword.VOID}) != null;
    }
}

