/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Expression;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1950", name="Cases in a \"switch\" should not have the same condition", priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleConstantRemediation(value="15min")
public class DuplicateSwitchCaseConditionCheck
extends SquidCheck<LexerlessGrammar> {
    private Map<String, AstNode> casesByCondition = Maps.newHashMap();

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.SWITCH_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        for (AstNode caseElement : astNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_ELEMENT})) {
            for (AstNode caseLabel : caseElement.getChildren(new AstNodeType[]{FlexGrammar.CASE_LABEL})) {
                if (caseLabel.getFirstChild().is(new AstNodeType[]{FlexKeyword.DEFAULT})) continue;
                this.checkCondition(caseLabel);
            }
        }
        this.casesByCondition.clear();
    }

    private void checkCondition(AstNode caseLabel) {
        String expression = Expression.exprToString(caseLabel.getFirstChild(new AstNodeType[]{FlexGrammar.LIST_EXPRESSION}));
        AstNode duplicateCase = this.casesByCondition.get(expression);
        if (duplicateCase != null) {
            this.getContext().createLineViolation((CodeCheck)this, "This case duplicates the case on line {0} with condition \"{1}\".", caseLabel, new Object[]{duplicateCase.getTokenLine(), expression});
        } else {
            this.casesByCondition.put(expression, caseLabel);
        }
    }
}

