/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexPunctuator;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1186", name="Methods should not be empty", priority=Priority.MAJOR, tags={"suspicious"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class EmptyMethodCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void visitNode(AstNode astNode) {
        for (AstNode function : Clazz.getFunctions(astNode)) {
            AstNode block = function.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK});
            if (block == null || !EmptyMethodCheck.isEmptyBlock(block)) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Add a nested comment explaining why this method is empty, throw an NotSupportedException or complete the implementation.", function, new Object[0]);
        }
    }

    private static boolean isEmptyBlock(AstNode block) {
        AstNode rightCurlyBrace = block.getFirstChild(new AstNodeType[]{FlexPunctuator.RCURLYBRACE});
        return !block.getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).hasChildren() && !EmptyMethodCheck.hasComment(rightCurlyBrace);
    }

    private static boolean hasComment(AstNode node) {
        return node.getToken().hasTrivia();
    }
}

