/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexPunctuator;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S108", name="Nested blocks of code should not be left empty", priority=Priority.MAJOR, tags={"suspicious"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class EmptyNestedBlockCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.BLOCK});
    }

    public void visitNode(AstNode astNode) {
        if (!astNode.getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).hasChildren() && EmptyNestedBlockCheck.isNested(astNode) && !EmptyNestedBlockCheck.hasComment(astNode)) {
            this.getContext().createLineViolation((CodeCheck)this, "Either remove or fill this block of code.", astNode, new Object[0]);
        }
    }

    private static boolean isNested(AstNode blockNode) {
        return !blockNode.getParent().is(new AstNodeType[]{FlexGrammar.CLASS_DEF, FlexGrammar.INTERFACE_DEF, FlexGrammar.PACKAGE_DEF, FlexGrammar.FUNCTION_COMMON});
    }

    private static boolean hasComment(AstNode blockNode) {
        return blockNode.getFirstChild(new AstNodeType[]{FlexPunctuator.RCURLYBRACE}).getToken().hasTrivia();
    }
}

