/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1116", name="Empty statements should be removed", priority=Priority.MINOR, tags={"cert", "misra", "unused"})
@ActivatedByDefault
@SqaleConstantRemediation(value="2min")
public class EmptyStatementCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.EMPTY_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        this.getContext().createLineViolation((CodeCheck)this, "Remove this empty statement.", astNode, new Object[0]);
    }
}

