/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexPunctuator;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1440", name="\"===\" and \"!==\" should be used instead of \"==\" and \"!=\"", priority=Priority.MAJOR, tags={"suspicious"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class EqEqEqCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexPunctuator.EQUAL2, FlexPunctuator.NOTEQUAL1});
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexPunctuator.EQUAL2})) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace == with ===", astNode, new Object[0]);
        } else {
            this.getContext().createLineViolation((CodeCheck)this, "Replace != with !==", astNode, new Object[0]);
        }
    }
}

