/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.MetadataTag;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1463", name="Event types should be defined in metadata tags", priority=Priority.MAJOR, tags={"design"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class EventMetadataShouldBeTypedCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.METADATA_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        Map<String, String> properties;
        if (MetadataTag.isTag(astNode, "Event") && (properties = MetadataTag.getTagPropertiesMap(astNode)) != null && !properties.containsKey("type")) {
            this.getContext().createLineViolation((CodeCheck)this, "The {0} event type is missing in this metadata tag", astNode, new Object[]{properties.get("name")});
        }
    }
}

