/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Variable;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S116", name="Field names should comply with a naming convention", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleConstantRemediation(value="2min")
public class FieldNameCheck
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT = "^[_a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    @RuleProperty(key="format", description="Regular expression used to check the field names against", defaultValue="^[_a-z][a-zA-Z0-9]*$")
    String format = "^[_a-z][a-zA-Z0-9]*$";

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
    }

    public void visitNode(AstNode astNode) {
        for (AstNode directive : Clazz.getDirectives(astNode)) {
            if (!Variable.isVariable(directive)) continue;
            AstNode variableDeclStatement = directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}).getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT});
            this.visitVariableDeclStatement(variableDeclStatement);
        }
    }

    private void visitVariableDeclStatement(AstNode variableDeclStatement) {
        for (AstNode identifier : Variable.getDeclaredIdentifiers(variableDeclStatement)) {
            if (this.pattern.matcher(identifier.getTokenValue()).matches()) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Rename this field name to match the regular expression {0}", identifier, new Object[]{this.format});
        }
    }
}

