/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.api.FlexMetric;
import org.sonar.flex.checks.utils.FlexCheck;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.api.SourceFunction;
import org.sonar.squidbridge.measures.MetricDef;

@Rule(key="FunctionComplexity", name="Functions should not be too complex", priority=Priority.MAJOR, tags={"brain-overload"})
@ActivatedByDefault
@SqaleLinearWithOffsetRemediation(coeff="1min", offset="10min", effortToFixDescription="per complexity point above the threshold")
public class FunctionComplexityCheck
extends FlexCheck {
    private static final int DEFAULT_MAXIMUM_FUNCTION_COMPLEXITY_THRESHOLD = 10;
    @RuleProperty(key="maximumFunctionComplexityThreshold", description="The maximum authorized complexity.", defaultValue="10")
    private int maximumFunctionComplexityThreshold = 10;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.FUNCTION_DEF, FlexGrammar.FUNCTION_EXPR});
    }

    public void leaveNode(AstNode node) {
        SourceFunction function = (SourceFunction)this.getContext().peekSourceCode();
        int functionComplexity = function.getInt((MetricDef)FlexMetric.COMPLEXITY);
        if (functionComplexity > this.maximumFunctionComplexityThreshold) {
            String message = String.format("Function has a complexity of %s which is greater than %s authorized.", functionComplexity, this.maximumFunctionComplexityThreshold);
            this.createIssueWithCost(message, node, (double)functionComplexity - (double)this.maximumFunctionComplexityThreshold);
        }
    }

    public void setMaximumFunctionComplexityThreshold(int threshold) {
        this.maximumFunctionComplexityThreshold = threshold;
    }
}

