/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Function;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S100", name="Function names should comply with a naming convention", tags={"convention"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class FunctionNameCheck
extends SquidCheck<LexerlessGrammar> {
    private static final String DEFAULT = "^[a-z][a-zA-Z0-9]*$";
    private Pattern pattern = null;
    private Deque<String> classes = new ArrayDeque<String>();
    @RuleProperty(key="format", description="Regular expression used to check the function names against", defaultValue="^[a-z][a-zA-Z0-9]*$")
    String format = "^[a-z][a-zA-Z0-9]*$";

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.FUNCTION_DEF, FlexGrammar.CLASS_DEF});
    }

    public void visitFile(@Nullable AstNode astNode) {
        if (this.pattern == null) {
            this.pattern = Pattern.compile(this.format);
        }
        this.classes.clear();
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF})) {
            this.classes.push(Clazz.getName(astNode));
        } else {
            String functionName = Function.getName(astNode);
            if (!this.isConstructor(astNode) && !this.pattern.matcher(functionName).matches()) {
                this.getContext().createLineViolation((CodeCheck)this, "Rename this \"{0}\" function to match the regular expression {1}", astNode, new Object[]{functionName, this.format});
            }
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF})) {
            this.classes.pop();
        }
    }

    private boolean isConstructor(AstNode functionNode) {
        return !this.classes.isEmpty() && Function.isConstructor(functionNode, this.classes.peek());
    }
}

