/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Function;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1185", name="Overriding methods should do more than simply call the same method in the super class", tags={"clumsy"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class FunctionOnlyCallsSuperCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.FUNCTION_DEF});
    }

    public void visitNode(AstNode astNode) {
        if (!FunctionOnlyCallsSuperCheck.isOverridingParentFunction(astNode.getPreviousAstNode())) {
            return;
        }
        AstNode singleDirectiveNode = FunctionOnlyCallsSuperCheck.getSingleStatementBlock(astNode);
        if (singleDirectiveNode != null && FunctionOnlyCallsSuperCheck.isSuperOrReturnOfSuperReference(singleDirectiveNode.getFirstChild())) {
            List<String> parameters = FunctionOnlyCallsSuperCheck.getParametersName(astNode);
            String methodName = Function.getName(astNode);
            if (FunctionOnlyCallsSuperCheck.isUselessCallToSuper(singleDirectiveNode.getFirstChild(new AstNodeType[]{FlexGrammar.STATEMENT}), methodName, parameters) && !FunctionOnlyCallsSuperCheck.hasMetadataTag(astNode.getParent().getParent().getPreviousAstNode())) {
                this.getContext().createLineViolation((CodeCheck)this, "Remove this method \"{0}\" to simply inherit it.", astNode, new Object[]{methodName});
            }
        }
    }

    private static boolean hasMetadataTag(AstNode directive) {
        return directive.getFirstChild().is(new AstNodeType[]{FlexGrammar.STATEMENT}) && directive.getFirstChild().getFirstChild().is(new AstNodeType[]{FlexGrammar.METADATA_STATEMENT});
    }

    private static AstNode getSingleStatementBlock(AstNode functionDef) {
        AstNode functionBlock = functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK});
        if (functionBlock != null && functionBlock.getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getNumberOfChildren() == 1) {
            return functionBlock.getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getFirstChild();
        }
        return null;
    }

    private static boolean isSuperReference(AstNode statement) {
        return statement.getFirstChild(new AstNodeType[]{FlexGrammar.EXPRESSION_STATEMENT}) != null && FunctionOnlyCallsSuperCheck.isSuperExpression(statement.getFirstChild().getFirstChild().getFirstChild());
    }

    private static boolean isSuperExpression(AstNode listExpression) {
        AstNode postfixExpr = listExpression.getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR}).getFirstChild(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR});
        return postfixExpr != null && postfixExpr.getFirstChild(new AstNodeType[]{FlexGrammar.SUPER_EXPR}) != null;
    }

    private static boolean isReturnOfSuperReference(AstNode statement) {
        return statement.getFirstChild().is(new AstNodeType[]{FlexGrammar.RETURN_STATEMENT}) && statement.getFirstChild().getFirstChild(new AstNodeType[]{FlexGrammar.LIST_EXPRESSION}) != null && FunctionOnlyCallsSuperCheck.isSuperExpression(statement.getFirstChild().getFirstChild(new AstNodeType[]{FlexGrammar.LIST_EXPRESSION}));
    }

    private static boolean isSuperOrReturnOfSuperReference(AstNode directiveChild) {
        return directiveChild.is(new AstNodeType[]{FlexGrammar.STATEMENT}) && (FunctionOnlyCallsSuperCheck.isSuperReference(directiveChild) || FunctionOnlyCallsSuperCheck.isReturnOfSuperReference(directiveChild));
    }

    private static List<String> getParametersName(AstNode functionDef) {
        ArrayList parametersNames = Lists.newArrayList();
        for (AstNode identifier : Function.getParametersIdentifiers(functionDef)) {
            parametersNames.add(identifier.getTokenValue());
        }
        return parametersNames;
    }

    private static boolean isOverridingParentFunction(AstNode attributesNode) {
        if (attributesNode != null && attributesNode.is(new AstNodeType[]{FlexGrammar.ATTRIBUTES})) {
            for (AstNode attribute : attributesNode.getChildren()) {
                if (!attribute.getFirstChild().is(new AstNodeType[]{FlexGrammar.ATTRIBUTE_EXPR}) || attribute.getFirstChild().getNumberOfChildren() != 1 || !attribute.getFirstChild().getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER}).getTokenValue().equals(FlexKeyword.OVERRIDE.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isUselessCallToSuper(AstNode singleStatement, String methodName, List<String> parameters) {
        String expected;
        StringBuilder sb = new StringBuilder();
        for (Token token : singleStatement.getFirstChild().getTokens()) {
            sb.append(token.getValue());
        }
        String actual = sb.toString();
        return actual.equals(expected = FlexKeyword.SUPER.getValue() + "." + methodName + "(" + Joiner.on((String)",").join(parameters) + ");") || actual.equals(FlexKeyword.RETURN.getValue() + expected);
    }
}

