/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1462", name="Event names should not be hardcoded in event listeners", priority=Priority.MAJOR, tags={"design"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class HardcodedEventNameCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private static final Pattern STRING_PATTERN = Pattern.compile("(?:\"([^\"\\\\]*+(\\\\[\\s\\S])?+)*+\"|'([^'\\\\]*+(\\\\[\\s\\S])?+)*+')");
    private static final State[][] TRANSITIONS = new State[State.values().length][Symbol.values().length];
    private State currentState;

    public void visitFile(@Nullable AstNode astNode) {
        this.currentState = State.EXPECTING_ADD_EVENT;
    }

    public void visitToken(Token token) {
        this.currentState = TRANSITIONS[this.currentState.ordinal()][HardcodedEventNameCheck.getSymbol(token.getValue()).ordinal()];
        if (this.currentState == State.FOUND_ISSUE) {
            this.getContext().createLineViolation((CodeCheck)this, "The event name {0} should be defined in a constant variable.", token, new Object[]{token.getValue()});
            this.currentState = State.EXPECTING_ADD_EVENT;
        }
    }

    private static Symbol getSymbol(String value) {
        Symbol result = Symbol.OTHER;
        if ("(".equals(value)) {
            result = Symbol.BRACE;
        } else if ("addEventListener".equals(value)) {
            result = Symbol.ADD_EVENT;
        } else if (STRING_PATTERN.matcher(value).matches()) {
            result = Symbol.STRING;
        }
        return result;
    }

    static {
        for (int i = 0; i < TRANSITIONS.length; ++i) {
            for (int j = 0; j < TRANSITIONS[i].length; ++j) {
                HardcodedEventNameCheck.TRANSITIONS[i][j] = State.EXPECTING_ADD_EVENT;
            }
        }
        HardcodedEventNameCheck.TRANSITIONS[State.EXPECTING_ADD_EVENT.ordinal()][Symbol.ADD_EVENT.ordinal()] = State.EXPECTING_BRACE;
        HardcodedEventNameCheck.TRANSITIONS[State.EXPECTING_BRACE.ordinal()][Symbol.BRACE.ordinal()] = State.EXPECTING_STRING;
        HardcodedEventNameCheck.TRANSITIONS[State.EXPECTING_STRING.ordinal()][Symbol.STRING.ordinal()] = State.FOUND_ISSUE;
    }

    private static enum Symbol {
        OTHER,
        ADD_EVENT,
        BRACE,
        STRING;

    }

    private static enum State {
        EXPECTING_ADD_EVENT,
        EXPECTING_BRACE,
        EXPECTING_STRING,
        FOUND_ISSUE;

    }
}

