/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1439", name="Only \"while\", \"do\" and \"for\" statements should be labelled", priority=Priority.MAJOR, tags={"pitfall"})
@ActivatedByDefault
@SqaleConstantRemediation(value="20min")
public class LabelPlacementCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.LABELED_STATEMENT});
    }

    public void visitNode(AstNode astNode) {
        if (!LabelPlacementCheck.isIterationStatement(astNode.getFirstChild(new AstNodeType[]{FlexGrammar.SUB_STATEMENT}))) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this ''{0}'' label.", astNode, new Object[]{astNode.getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER}).getTokenValue()});
        }
    }

    private static boolean isIterationStatement(AstNode subStatement) {
        AstNode astNode = subStatement.getFirstChild();
        return astNode.is(new AstNodeType[]{FlexGrammar.STATEMENT}) && astNode.getFirstChild().is(new AstNodeType[]{FlexGrammar.WHILE_STATEMENT, FlexGrammar.DO_STATEMENT, FlexGrammar.FOR_STATEMENT});
    }
}

