/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Function;
import org.sonar.flex.checks.utils.Modifiers;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1784", name="Method visibility should be explicitly declared", priority=Priority.MINOR, tags={"convention"})
@SqaleConstantRemediation(value="2min")
public class MethodVisibilityCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CLASS_DEF});
    }

    public void visitNode(AstNode astNode) {
        List directives = astNode.getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK}).getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getChildren();
        if (directives == null) {
            return;
        }
        for (AstNode directive : directives) {
            AstNode annotableDirectiveChild;
            AstNode annotableDirective = directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE});
            if (annotableDirective == null || !(annotableDirectiveChild = annotableDirective.getFirstChild()).is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF}) || MethodVisibilityCheck.hasVisibility(annotableDirectiveChild)) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Explicitly declare the visibility of this method \"{0}\".", annotableDirectiveChild, new Object[]{Function.getName(annotableDirectiveChild)});
        }
    }

    private static boolean hasVisibility(AstNode functionDef) {
        Set<AstNodeType> modifiers = Modifiers.getModifiers(functionDef.getPreviousAstNode());
        for (AstNodeType modifier : modifiers) {
            if (!MethodVisibilityCheck.isVisibility(modifier)) continue;
            return true;
        }
        return false;
    }

    private static boolean isVisibility(AstNodeType modifier) {
        return modifier.equals(FlexKeyword.PUBLIC) || modifier.equals(FlexKeyword.INTERNAL) || modifier.equals(FlexKeyword.PROTECTED) || modifier.equals(FlexKeyword.PRIVATE);
    }
}

