/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Iterables;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="NonEmptyCaseWithoutBreak", name="Switch cases should end with an unconditional \"break\" statement", priority=Priority.CRITICAL, tags={"cwe", "misra", "cert", "pitfall"})
@ActivatedByDefault
@SqaleConstantRemediation(value="10min")
public class NonEmptyCaseWithoutBreakCheck
extends SquidCheck<LexerlessGrammar> {
    private static final AstNodeType[] JUMP_NODES = new AstNodeType[]{FlexGrammar.BREAK_STATEMENT, FlexGrammar.RETURN_STATEMENT, FlexGrammar.THROW_STATEMENT, FlexGrammar.CONTINUE_STATEMENT};

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.CASE_ELEMENT});
    }

    public void visitNode(AstNode astNode) {
        if (NonEmptyCaseWithoutBreakCheck.isLastCaseElement(astNode)) {
            return;
        }
        int jumpStmtNumber = astNode.getDescendants(JUMP_NODES).size();
        if (jumpStmtNumber < 2) {
            AstNode directive = astNode.getLastChild();
            this.visitLastDirective(astNode, directive);
        }
    }

    private static boolean isLastCaseElement(AstNode astNode) {
        return astNode.getNextSibling().isNot(new AstNodeType[]{FlexGrammar.CASE_ELEMENT});
    }

    private void visitLastDirective(AstNode astNode, AstNode directive) {
        if (NonEmptyCaseWithoutBreakCheck.isBlock(directive)) {
            this.visitLastDirective(astNode, directive.getFirstChild().getFirstChild().getLastChild());
            return;
        }
        if (directive.getFirstChild().is(new AstNodeType[]{FlexGrammar.STATEMENT}) && directive.getFirstChild().getFirstChild().isNot(JUMP_NODES)) {
            this.getContext().createLineViolation((CodeCheck)this, "Last statement in this switch-clause should be an unconditional break.", (AstNode)Iterables.getLast((Iterable)astNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_LABEL})), new Object[0]);
        }
    }

    private static boolean isBlock(AstNode directive) {
        return directive.getNumberOfChildren() == 1 && directive.getFirstChild().is(new AstNodeType[]{FlexGrammar.STATEMENT}) && directive.getFirstChild().getNumberOfChildren() == 1 && directive.getFirstChild().getFirstChild().is(new AstNodeType[]{FlexGrammar.BLOCK});
    }
}

