/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1434", name="Variables of the \"Object\" type should not be used", priority=Priority.MAJOR, tags={"suspicious"})
@ActivatedByDefault
@SqaleConstantRemediation(value="20min")
public class ObjectTypeUseCheck
extends SquidCheck<LexerlessGrammar> {
    private static final String OBJECT_TYPE = "Object";

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.VARIABLE_DEF});
    }

    public void visitNode(AstNode astNode) {
        for (AstNode varBinding : astNode.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING_LIST}).getChildren(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING})) {
            if (!ObjectTypeUseCheck.isDeclareAsObject(varBinding) && !ObjectTypeUseCheck.isInitialisedAsObject(varBinding.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_INITIALISATION}))) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Clearly define the type of this ''{0}'' variable", astNode, new Object[]{varBinding.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}).getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER}).getTokenValue()});
        }
    }

    private static boolean isDeclareAsObject(AstNode varBinding) {
        AstNode typeExpr = varBinding.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}).getFirstChild(new AstNodeType[]{FlexGrammar.TYPE_EXPR});
        return typeExpr != null && OBJECT_TYPE.equals(typeExpr.getTokenValue());
    }

    private static boolean isInitialisedAsObject(AstNode varInitialisation) {
        AstNode assignmentExpr;
        if (varInitialisation != null && (assignmentExpr = varInitialisation.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_INITIALISER}).getFirstChild(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR})) != null && assignmentExpr.getNumberOfChildren() == 1 && assignmentExpr.getFirstChild().is(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR})) {
            AstNode postfixExprChild = assignmentExpr.getFirstChild(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR}).getFirstChild();
            if (postfixExprChild.is(new AstNodeType[]{FlexGrammar.PRIMARY_EXPR})) {
                return postfixExprChild.getFirstChild().is(new AstNodeType[]{FlexGrammar.OBJECT_INITIALISER});
            }
            if (postfixExprChild.is(new AstNodeType[]{FlexGrammar.FULL_NEW_EXPR, FlexGrammar.SHORT_NEW_EXPR})) {
                AstNode subExpr = postfixExprChild.getFirstChild(new AstNodeType[]{FlexGrammar.FULL_NEW_SUB_EXPR, FlexGrammar.SHORT_NEW_SUB_EXPR});
                return subExpr != null && OBJECT_TYPE.equals(subExpr.getTokenValue());
            }
        }
        return false;
    }
}

