/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.checks.AbstractOneStatementPerLineCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="OneStatementPerLine", name="Statements should be on separate lines", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleConstantRemediation(value="1min")
public class OneStatementPerLineCheck
extends AbstractOneStatementPerLineCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.STATEMENT, FlexGrammar.VARIABLE_DECLARATION_STATEMENT});
    }

    public AstNodeType getStatementRule() {
        return null;
    }

    public boolean isExcluded(AstNode astNode) {
        AstNode statementNode = astNode.getFirstChild();
        return statementNode.is(new AstNodeType[]{FlexGrammar.BLOCK}) || statementNode.is(new AstNodeType[]{FlexGrammar.EMPTY_STATEMENT}) || statementNode.is(new AstNodeType[]{FlexGrammar.LABELED_STATEMENT});
    }
}

