/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexPunctuator;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1438", name="Statements should end with semicolons", priority=Priority.MINOR, tags={"convention"})
@ActivatedByDefault
@SqaleConstantRemediation(value="1min")
public class SemicolonCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.EOS, FlexGrammar.EOS_NO_LB});
    }

    public void visitNode(AstNode astNode) {
        Token lastToken = astNode.getLastToken();
        if (lastToken == null || !FlexPunctuator.SEMICOLON.getValue().equals(lastToken.getValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Add a semicolon at the end of this statement", astNode.getParent().getLastToken(), new Object[0]);
        }
    }
}

