/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstAndTokenVisitor;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.Token;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1465", name="LocalConnection should be configured to narrowly specify the domains with which local connections to other Flex application are allowed", priority=Priority.CRITICAL, tags={"security"})
@ActivatedByDefault
@SqaleConstantRemediation(value="10min")
public class StarUseForLocalConnectionCheck
extends SquidCheck<LexerlessGrammar>
implements AstAndTokenVisitor {
    private Token previousToken = null;
    private static final State[][] TRANSITIONS = new State[State.values().length][Symbol.values().length];
    private State currentState;

    public void visitFile(@Nullable AstNode node) {
        this.currentState = State.EXPECTING_DOT;
    }

    public void visitToken(Token token) {
        this.currentState = TRANSITIONS[this.currentState.ordinal()][this.getSymbol(token.getOriginalValue()).ordinal()];
        if (this.currentState == State.FOUND_ISSUE) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace this wildcard character '*' with a well defined domain", token, new Object[0]);
            this.currentState = State.EXPECTING_DOT;
        }
        this.previousToken = token;
    }

    private Symbol getSymbol(String value) {
        Symbol result = Symbol.OTHER;
        if (".".equals(value) && this.previousToken != null && !"Security".equals(this.previousToken.getValue())) {
            result = Symbol.DOT;
        } else if ("allowDomain".equals(value)) {
            result = Symbol.ALLOW_DOMAIN;
        } else if ("(".equals(value)) {
            result = Symbol.RCURLY;
        } else if ("\"*\"".equals(value)) {
            result = Symbol.STAR;
        }
        return result;
    }

    static {
        for (int i = 0; i < TRANSITIONS.length; ++i) {
            for (int j = 0; j < TRANSITIONS[i].length; ++j) {
                StarUseForLocalConnectionCheck.TRANSITIONS[i][j] = State.EXPECTING_DOT;
            }
        }
        StarUseForLocalConnectionCheck.TRANSITIONS[State.EXPECTING_DOT.ordinal()][Symbol.DOT.ordinal()] = State.EXPECTING_ALLOW_DOMAIN;
        StarUseForLocalConnectionCheck.TRANSITIONS[State.EXPECTING_ALLOW_DOMAIN.ordinal()][Symbol.ALLOW_DOMAIN.ordinal()] = State.EXPECTING_LCURLY;
        StarUseForLocalConnectionCheck.TRANSITIONS[State.EXPECTING_LCURLY.ordinal()][Symbol.RCURLY.ordinal()] = State.EXPECTING_STAR;
        StarUseForLocalConnectionCheck.TRANSITIONS[State.EXPECTING_STAR.ordinal()][Symbol.STAR.ordinal()] = State.FOUND_ISSUE;
    }

    private static enum Symbol {
        OTHER,
        DOT,
        ALLOW_DOMAIN,
        RCURLY,
        STAR;

    }

    private static enum State {
        EXPECTING_DOT,
        EXPECTING_ALLOW_DOMAIN,
        EXPECTING_LCURLY,
        EXPECTING_STAR,
        FOUND_ISSUE;

    }
}

