/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1951", name="The \"trace\" function should not be used", priority=Priority.CRITICAL, tags={"cwe", "security"})
@ActivatedByDefault
@SqaleConstantRemediation(value="2min")
public class TraceUseCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR});
    }

    public void visitNode(AstNode astNode) {
        if (TraceUseCheck.isFunctionCall(astNode) && "trace".equals(astNode.getFirstChild().getTokenValue())) {
            this.getContext().createLineViolation((CodeCheck)this, "Remove this use of the \"trace\" function.", astNode, new Object[0]);
        }
    }

    private static boolean isFunctionCall(AstNode postfixExpr) {
        return postfixExpr.getFirstChild().is(new AstNodeType[]{FlexGrammar.PRIMARY_EXPR}) && postfixExpr.getLastChild().is(new AstNodeType[]{FlexGrammar.ARGUMENTS});
    }
}

