/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Variable;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="S1481", name="Unused local variables should be removed", priority=Priority.MAJOR, tags={"unused"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class UnusedLocalVariableCheck
extends SquidCheck<LexerlessGrammar> {
    private Scope currentScope;

    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.FUNCTION_DEF, FlexGrammar.VARIABLE_DECLARATION_STATEMENT, FlexGrammar.QUALIFIED_IDENTIFIER});
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.currentScope = null;
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF})) {
            this.currentScope = new Scope(this.currentScope);
        } else if (this.currentScope != null && astNode.is(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT})) {
            for (AstNode varIdentifier : Variable.getDeclaredIdentifiers(astNode)) {
                this.currentScope.declare(varIdentifier);
            }
        } else if (this.currentScope != null && astNode.is(new AstNodeType[]{FlexGrammar.QUALIFIED_IDENTIFIER})) {
            this.currentScope.use(astNode);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF})) {
            this.reportUnusedVariable();
            this.currentScope = this.currentScope.outerScope;
        }
    }

    private void reportUnusedVariable() {
        for (Map.Entry entry : this.currentScope.variables.entrySet()) {
            if (((LocalVariable)entry.getValue()).usages != 0) continue;
            this.getContext().createLineViolation((CodeCheck)this, "Remove this unused ''{0}'' local variable.", ((LocalVariable)entry.getValue()).declaration, new Object[]{entry.getKey()});
        }
    }

    private static class Scope {
        private final Scope outerScope;
        private final Map<String, LocalVariable> variables;

        public Scope(Scope outerScope) {
            this.outerScope = outerScope;
            this.variables = Maps.newHashMap();
        }

        private void declare(AstNode astNode) {
            String identifier = astNode.getTokenValue();
            if (!this.variables.containsKey(identifier)) {
                this.variables.put(identifier, new LocalVariable(astNode, 0));
            }
        }

        private void use(AstNode astNode) {
            String identifier = astNode.getTokenValue();
            Scope scope = this;
            while (scope != null) {
                LocalVariable var = scope.variables.get(identifier);
                if (var != null) {
                    ++var.usages;
                    return;
                }
                scope = scope.outerScope;
            }
        }
    }

    private static class LocalVariable {
        final AstNode declaration;
        int usages;

        private LocalVariable(AstNode declaration, int usages) {
            this.declaration = declaration;
            this.usages = usages;
        }
    }
}

