/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.flex.FlexGrammar;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="WithStatement", name="\"with\" statements should not be used", priority=Priority.MAJOR, tags={"bug"})
@ActivatedByDefault
@SqaleConstantRemediation(value="5min")
public class WithStatementCheck
extends SquidCheck<LexerlessGrammar> {
    public void init() {
        this.subscribeTo(new AstNodeType[]{FlexGrammar.WITH_STATEMENT});
    }

    public void visitNode(AstNode node) {
        this.getContext().createLineViolation((CodeCheck)this, "Usage of \"with\" statement should be avoided. Instead, prefer explicitly specify variable scopes to make code clearer.", node, new Object[0]);
    }
}

