/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.FlexPunctuator;

@Rule(key="SwitchWithoutDefault")
public class SwitchWithoutDefaultCheck
extends FlexCheck {
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.SWITCH_STATEMENT);
    }

    public void visitNode(AstNode astNode) {
        AstNode defaultCaseElement = null;
        block0: for (AstNode caseElementNode : astNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_ELEMENT})) {
            for (AstNode caseLabelNode : caseElementNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_LABEL})) {
                if (!caseLabelNode.getFirstChild().is(new AstNodeType[]{FlexKeyword.DEFAULT})) continue;
                defaultCaseElement = caseElementNode;
                continue block0;
            }
        }
        if (defaultCaseElement == null) {
            this.addIssue("Avoid switch statement without a \"default\" clause.", astNode);
        } else if (defaultCaseElement.getNextSibling().isNot(new AstNodeType[]{FlexPunctuator.RCURLYBRACE})) {
            this.addIssue("\"default\" clause should be the last one.", astNode);
        }
    }
}

