/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;

@Rule(key="S1951")
public class TraceUseCheck
extends FlexCheck {
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.POSTFIX_EXPR);
    }

    public void visitNode(AstNode astNode) {
        if (TraceUseCheck.isFunctionCall(astNode) && "trace".equals(astNode.getFirstChild().getTokenValue())) {
            this.addIssue("Remove this use of the \"trace\" function.", astNode);
        }
    }

    private static boolean isFunctionCall(AstNode postfixExpr) {
        return postfixExpr.getFirstChild().is(new AstNodeType[]{FlexGrammar.PRIMARY_EXPR}) && postfixExpr.getLastChild().is(new AstNodeType[]{FlexGrammar.ARGUMENTS});
    }
}

