/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Sets;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexPunctuator;
import org.sonar.flex.checks.utils.Expression;

@Rule(key="S127")
public class VariantStopConditionInForLoopCheck
extends FlexCheck {
    Set<String> counters = Sets.newHashSet();
    Set<String> pendingCounters = Sets.newHashSet();

    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.FOR_STATEMENT, FlexGrammar.SUB_STATEMENT, FlexGrammar.ASSIGNMENT_EXPR, FlexPunctuator.DOUBLE_PLUS, FlexPunctuator.DOUBLE_MINUS);
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.counters.clear();
        this.pendingCounters.clear();
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.FOR_STATEMENT})) {
            this.pendingCounters.addAll(VariantStopConditionInForLoopCheck.getLoopsCounters(astNode));
            this.checkLoopsCondition(astNode);
        } else if (astNode.is(new AstNodeType[]{FlexGrammar.SUB_STATEMENT}) && !this.pendingCounters.isEmpty()) {
            this.counters.addAll(this.pendingCounters);
            this.pendingCounters.clear();
        } else if (!this.counters.isEmpty() && astNode.is(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR, FlexPunctuator.DOUBLE_PLUS, FlexPunctuator.DOUBLE_MINUS})) {
            this.checkIfModifyingCounter(astNode);
        }
    }

    private void checkLoopsCondition(AstNode forStatement) {
        AstNode stopConditionExpr = VariantStopConditionInForLoopCheck.getStopCondition(forStatement);
        if (stopConditionExpr == null) {
            return;
        }
        block0: for (AstNode assignmentExpr : stopConditionExpr.getChildren(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR})) {
            for (Token t : assignmentExpr.getTokens()) {
                String tokenValue = t.getValue();
                if (!FlexPunctuator.LPARENTHESIS.getValue().equals(tokenValue) && !FlexPunctuator.DOT.getValue().equals(tokenValue)) continue;
                this.addIssue("Calculate the stop condition value outside the loop and set it to a variable.", assignmentExpr);
                continue block0;
            }
        }
    }

    @Nullable
    private static AstNode getStopCondition(AstNode forStatement) {
        AstNode semicolonNode = forStatement.getFirstChild(new AstNodeType[]{FlexPunctuator.SEMICOLON});
        if (semicolonNode != null) {
            AstNode stopConditionExpr = semicolonNode.getNextAstNode();
            return stopConditionExpr.is(new AstNodeType[]{FlexGrammar.LIST_EXPRESSION}) ? stopConditionExpr : null;
        }
        return null;
    }

    private void checkIfModifyingCounter(AstNode expression) {
        String varName;
        AstNode varNode = null;
        if (expression.is(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR}) && expression.hasDirectChildren(new AstNodeType[]{FlexGrammar.ASSIGNMENT_OPERATOR})) {
            varNode = expression.getFirstChild();
        } else if (expression.is(new AstNodeType[]{FlexPunctuator.DOUBLE_PLUS, FlexPunctuator.DOUBLE_MINUS})) {
            AstNode exprParent = expression.getParent();
            AstNode astNode = varNode = exprParent.is(new AstNodeType[]{FlexGrammar.UNARY_EXPR}) ? exprParent.getLastChild() : exprParent.getFirstChild();
        }
        if (varNode != null && this.counters.contains(varName = Expression.exprToString(varNode))) {
            this.addIssue(MessageFormat.format("Do not update the loop counter \"{0}\" within the loop body.", varName), varNode);
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.FOR_STATEMENT})) {
            this.counters.removeAll(VariantStopConditionInForLoopCheck.getLoopsCounters(astNode));
        }
    }

    private static Set<String> getLoopsCounters(AstNode forStatement) {
        HashSet loopCounters = Sets.newHashSet();
        AstNode initialiser = forStatement.getFirstChild(new AstNodeType[]{FlexGrammar.FOR_INITIALISER});
        if (initialiser != null) {
            AstNode initialiserExpr = initialiser.getFirstChild();
            if (initialiserExpr.is(new AstNodeType[]{FlexGrammar.VARIABLE_DEF_NO_IN})) {
                VariantStopConditionInForLoopCheck.getCountersFromVariableDef(loopCounters, initialiserExpr);
            } else {
                VariantStopConditionInForLoopCheck.getCountersFromListExpression(loopCounters, initialiserExpr);
            }
        }
        return loopCounters;
    }

    private static void getCountersFromListExpression(Set<String> counters, AstNode initialiserExpr) {
        for (AstNode assignmentExpr : initialiserExpr.getChildren(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR_NO_IN})) {
            AstNode exprFirstChild = assignmentExpr.getFirstChild();
            if (assignmentExpr.hasDirectChildren(new AstNodeType[]{FlexGrammar.ASSIGNMENT_OPERATOR})) {
                counters.add(Expression.exprToString(exprFirstChild));
                continue;
            }
            if (exprFirstChild.is(new AstNodeType[]{FlexGrammar.UNARY_EXPR})) {
                counters.add(Expression.exprToString(exprFirstChild.getLastChild()));
                continue;
            }
            if (!exprFirstChild.is(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR})) continue;
            counters.add(Expression.exprToString(exprFirstChild.getFirstChild()));
        }
    }

    private static void getCountersFromVariableDef(Set<String> counters, AstNode initialiserExpr) {
        for (AstNode variableBinding : initialiserExpr.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING_LIST_NO_IN}).getChildren(new AstNodeType[]{FlexGrammar.VARIABLE_BINDING_NO_IN})) {
            counters.add(Expression.exprToString(variableBinding.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER_NO_IN}).getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER})));
        }
    }
}

