/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;
import org.sonar.flex.checks.utils.Function;

@Rule(key="S1172")
public class UnusedFunctionParametersCheck
extends FlexCheck {
    private Deque<Boolean> classes = new ArrayDeque<Boolean>();
    private static final AstNodeType[] FUNCTION_NODES = new AstNodeType[]{FlexGrammar.FUNCTION_DEF, FlexGrammar.FUNCTION_EXPR};
    private Scope currentScope;

    public List<AstNodeType> subscribedTo() {
        ArrayList<AstNodeType> types = new ArrayList<AstNodeType>();
        types.add((AstNodeType)FlexGrammar.POSTFIX_EXPR);
        types.add((AstNodeType)FlexGrammar.PARAMETERS);
        types.add((AstNodeType)FlexGrammar.CLASS_DEF);
        Collections.addAll(types, FUNCTION_NODES);
        return types;
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.currentScope = null;
        this.classes.clear();
    }

    public void visitNode(AstNode astNode) {
        AstNode postfixExprChild;
        if (astNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF})) {
            this.classes.push(UnusedFunctionParametersCheck.implementsAnInterface(astNode));
        } else if (astNode.is(FUNCTION_NODES)) {
            this.currentScope = new Scope(this.currentScope, astNode);
        } else if (this.currentScope != null && astNode.is(new AstNodeType[]{FlexGrammar.PARAMETERS}) && astNode.getParent().is(new AstNodeType[]{FlexGrammar.FUNCTION_SIGNATURE})) {
            this.declareInCurrentScope(Function.getParametersIdentifiers(this.currentScope.functionDec));
        } else if (this.currentScope != null && astNode.is(new AstNodeType[]{FlexGrammar.POSTFIX_EXPR}) && (postfixExprChild = astNode.getFirstChild()).is(new AstNodeType[]{FlexGrammar.PRIMARY_EXPR}) && postfixExprChild.getNextAstNode().isNot(new AstNodeType[]{FlexGrammar.ARGUMENTS})) {
            this.currentScope.use(UnusedFunctionParametersCheck.getPrimaryExpressionStringValue(postfixExprChild));
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(FUNCTION_NODES) && UnusedFunctionParametersCheck.isNotAbstract(astNode)) {
            if (!this.isExcluded(astNode)) {
                this.reportUnusedArgument();
            }
            this.currentScope = this.currentScope.outerScope;
        } else if (astNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF})) {
            this.classes.pop();
        }
    }

    private void reportUnusedArgument() {
        int nbUnusedArgs = 0;
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : this.currentScope.arguments.entrySet()) {
            if ((Integer)entry.getValue() != 0) continue;
            builder.append((String)entry.getKey() + " ");
            ++nbUnusedArgs;
        }
        if (nbUnusedArgs > 0) {
            this.addIssue(MessageFormat.format("Remove the unused function {0} \"{1}\".", nbUnusedArgs > 1 ? "parameters" : "parameter", StringUtils.join((Object[])builder.toString().trim().split(" "), (String)", ")), this.currentScope.functionDec);
        }
    }

    private boolean isExcluded(AstNode functionDec) {
        AstNode directives = functionDec.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK}).getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES});
        return UnusedFunctionParametersCheck.isExcludedFunctionDeclaration(functionDec) || UnusedFunctionParametersCheck.isEmpty(directives) || UnusedFunctionParametersCheck.containsOnlyThrowStmt(directives) || this.isInClassImplementingInterface();
    }

    private static Boolean implementsAnInterface(AstNode classDef) {
        AstNode inheritenceNode = classDef.getFirstChild(new AstNodeType[]{FlexGrammar.INHERITENCE});
        return inheritenceNode != null && inheritenceNode.getFirstChild().is(new AstNodeType[]{FlexKeyword.IMPLEMENTS});
    }

    private boolean isInClassImplementingInterface() {
        return !this.classes.isEmpty() && this.classes.peek() != false;
    }

    private static boolean containsOnlyThrowStmt(AstNode directives) {
        List directiveList = directives.getChildren();
        if (directiveList.size() == 1) {
            AstNode directiveKind = ((AstNode)directiveList.get(0)).getFirstChild().getFirstChild();
            return directiveKind.is(new AstNodeType[]{FlexGrammar.THROW_STATEMENT});
        }
        return false;
    }

    private static boolean isEmpty(AstNode directives) {
        return directives.getNumberOfChildren() == 0;
    }

    private void declareInCurrentScope(List<AstNode> identifiers) {
        for (AstNode identifier : identifiers) {
            this.currentScope.declare(identifier);
        }
    }

    private static boolean isExcludedFunctionDeclaration(AstNode functionDec) {
        return functionDec.is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF}) && (Function.isOverriding(functionDec) || UnusedFunctionParametersCheck.isEventHandler(functionDec));
    }

    private static boolean isEventHandler(AstNode functionDec) {
        AstNode firstParameter;
        AstNode parameters;
        String functionName = functionDec.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_NAME}).getTokenValue();
        if ((functionName.toLowerCase(Locale.ENGLISH).contains("handle") || UnusedFunctionParametersCheck.startsWithOnPreposition(functionName)) && (parameters = functionDec.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_SIGNATURE}).getFirstChild(new AstNodeType[]{FlexGrammar.PARAMETERS})) != null && (firstParameter = parameters.getFirstChild(new AstNodeType[]{FlexGrammar.PARAMETER})) != null && firstParameter.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}) != null) {
            AstNode firstParameterType = firstParameter.getFirstChild(new AstNodeType[]{FlexGrammar.TYPED_IDENTIFIER}).getFirstChild(new AstNodeType[]{FlexGrammar.TYPE_EXPR});
            return firstParameterType != null && firstParameterType.getLastToken().getValue().endsWith("Event");
        }
        return false;
    }

    private static boolean startsWithOnPreposition(String name) {
        return name.startsWith("on") && (name.length() == 2 || name.substring(2, 3).matches("[A-Z]"));
    }

    private static boolean isNotAbstract(AstNode functionDef) {
        return functionDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getLastChild().is(new AstNodeType[]{FlexGrammar.BLOCK});
    }

    private static String getPrimaryExpressionStringValue(AstNode postfixExpr) {
        StringBuilder builder = new StringBuilder();
        for (Token t : postfixExpr.getTokens()) {
            builder.append(t.getValue());
        }
        return builder.toString();
    }

    private static class Scope {
        private final Scope outerScope;
        private final AstNode functionDec;
        private final Map<String, Integer> arguments;

        public Scope(Scope outerScope, AstNode functionDec) {
            this.outerScope = outerScope;
            this.functionDec = functionDec;
            this.arguments = Maps.newLinkedHashMap();
        }

        private void declare(AstNode astNode) {
            Preconditions.checkState((boolean)astNode.is(new AstNodeType[]{FlexGrammar.IDENTIFIER}));
            String identifier = astNode.getTokenValue();
            this.arguments.put(identifier, 0);
        }

        private void use(String value) {
            Scope scope = this;
            while (scope != null) {
                Integer usage = scope.arguments.get(value);
                if (usage != null) {
                    Integer n = usage;
                    Integer n2 = usage = Integer.valueOf(usage + 1);
                    scope.arguments.put(value, usage);
                    return;
                }
                scope = scope.outerScope;
            }
        }
    }
}

