/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sonar.sslr.api.AstNodeType;
import com.sonar.sslr.api.Token;
import com.sonar.sslr.api.Trivia;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;

@Rule(key="CommentRegularExpression")
public class CommentRegularExpressionCheck
extends FlexCheck {
    private static final String DEFAULT_REGULAR_EXPRESSION = "";
    private static final String DEFAULT_MESSAGE = "The regular expression matches this comment.";
    @RuleProperty(key="regularExpression", description="The regular expression", defaultValue="")
    public String regularExpression = "";
    @RuleProperty(key="message", description="The issue message", defaultValue="The regular expression matches this comment.")
    public String message = "The regular expression matches this comment.";
    private Pattern pattern = null;

    public List<AstNodeType> subscribedTo() {
        return Collections.emptyList();
    }

    public Pattern pattern() {
        if (this.pattern == null) {
            Preconditions.checkNotNull((Object)this.regularExpression, (Object)"getRegularExpression() should not return null");
            if (!Strings.isNullOrEmpty((String)this.regularExpression)) {
                try {
                    this.pattern = Pattern.compile(this.regularExpression, 32);
                }
                catch (RuntimeException e) {
                    throw new IllegalStateException("Unable to compile regular expression: " + this.regularExpression, e);
                }
            }
        }
        return this.pattern;
    }

    public void visitToken(Token token) {
        Pattern regexp = this.pattern();
        if (regexp != null) {
            for (Trivia trivia : token.getTrivia()) {
                if (!trivia.isComment() || !regexp.matcher(trivia.getToken().getOriginalValue()).matches()) continue;
                this.addIssue(this.message, trivia.getToken());
            }
        }
    }
}

