/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.google.common.collect.Iterables;
import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.metrics.FileLinesVisitor;

@Rule(key="S1151")
public class TooManyLinesInCaseCheck
extends FlexCheck {
    private static final int DEFAULT = 5;
    @RuleProperty(key="max", description="Maximum number of lines", defaultValue="5")
    int max = 5;

    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CASE_ELEMENT);
    }

    public void visitNode(AstNode astNode) {
        FileLinesVisitor linesVisitor = new FileLinesVisitor();
        linesVisitor.scanNode(astNode);
        AstNode firstLabelNode = (AstNode)Iterables.getFirst((Iterable)astNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_LABEL}), null);
        AstNode lastLabelNode = (AstNode)Iterables.getLast((Iterable)astNode.getChildren(new AstNodeType[]{FlexGrammar.CASE_LABEL}));
        int caseLabelLines = lastLabelNode.getTokenLine() - firstLabelNode.getTokenLine();
        int lines = linesVisitor.linesOfCode().size() - caseLabelLines;
        if (lines > this.max) {
            this.addIssue(MessageFormat.format("Reduce this switch case number of lines of code from {0} to at most {1}, for example by extracting code into methods.", lines, this.max), lastLabelNode);
        }
    }
}

