/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.metrics.ComplexityVisitor;

@Rule(key="ClassComplexity")
@Deprecated
public class ClassComplexityCheck
extends FlexCheck {
    private static final int DEFAULT_MAXIMUM_CLASS_COMPLEXITY_THRESHOLD = 80;
    @RuleProperty(key="maximumClassComplexityThreshold", description="Maximum complexity allowed.", defaultValue="80")
    private int maximumClassComplexityThreshold = 80;

    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CLASS_DEF);
    }

    public void visitNode(AstNode node) {
        int complexity = ComplexityVisitor.complexity((AstNode)node);
        if (complexity > this.maximumClassComplexityThreshold) {
            String message = String.format("Class has a complexity of %s which is greater than %s authorized.", complexity, this.maximumClassComplexityThreshold);
            this.addIssueWithCost(message, node, (double)complexity - (double)this.maximumClassComplexityThreshold);
        }
    }

    public void setMaximumClassComplexityThreshold(int threshold) {
        this.maximumClassComplexityThreshold = threshold;
    }
}

