/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Function;

@Rule(key="S1447")
public class ConstructorNotLightweightCheck
extends FlexCheck {
    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CLASS_DEF);
    }

    public void visitNode(AstNode astNode) {
        AstNode constructorDef = Clazz.getConstructor(astNode);
        if (constructorDef != null && ConstructorNotLightweightCheck.containsBranch(constructorDef)) {
            this.addIssue(MessageFormat.format("Extract the content of this \"{0}\" constructor into a dedicated function", Function.getName(constructorDef)), constructorDef);
        }
    }

    private static boolean containsBranch(AstNode constructorDef) {
        AstNode blockNode = constructorDef.getFirstChild(new AstNodeType[]{FlexGrammar.FUNCTION_COMMON}).getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK});
        if (blockNode != null) {
            for (AstNode directive : blockNode.getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getChildren()) {
                if (!ConstructorNotLightweightCheck.isBranch(directive)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isBranch(AstNode directive) {
        AstNode astNode = directive.getFirstChild();
        return astNode.is(new AstNodeType[]{FlexGrammar.STATEMENT}) && astNode.getFirstChild().is(new AstNodeType[]{FlexGrammar.IF_STATEMENT, FlexGrammar.SWITCH_STATEMENT, FlexGrammar.DO_STATEMENT, FlexGrammar.WHILE_STATEMENT, FlexGrammar.FOR_STATEMENT});
    }
}

