/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexPunctuator;

@Rule(key="S1454")
public class TooManyUnaryOperatorCheck
extends FlexCheck {
    private boolean assignmentExpression;
    private int counter;

    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.ASSIGNMENT_EXPR, FlexPunctuator.DOUBLE_MINUS, FlexPunctuator.DOUBLE_PLUS);
    }

    public void visitFile(@Nullable AstNode astNode) {
        this.assignmentExpression = false;
    }

    public void visitNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR})) {
            this.assignmentExpression = true;
        } else if (this.assignmentExpression && (astNode.is(new AstNodeType[]{FlexPunctuator.DOUBLE_MINUS}) || astNode.is(new AstNodeType[]{FlexPunctuator.DOUBLE_PLUS}))) {
            ++this.counter;
        }
    }

    public void leaveNode(AstNode astNode) {
        if (astNode.is(new AstNodeType[]{FlexGrammar.ASSIGNMENT_EXPR})) {
            if (this.counter > 1) {
                this.addIssue("Split this expression into multiple expressions so that each one contains no more than a single \"++\" or \"--\" unary operator", astNode);
            }
            this.assignmentExpression = false;
            this.counter = 0;
        }
    }
}

