/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks.utils;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Function;
import org.sonar.flex.checks.utils.Preconditions;

public final class Clazz {
    private Clazz() {
    }

    public static List<AstNode> getDirectives(AstNode classDefNode) {
        Preconditions.checkState(classDefNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF}));
        return classDefNode.getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK}).getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getChildren(new AstNodeType[]{FlexGrammar.DIRECTIVE});
    }

    public static List<AstNode> getFields(AstNode classDefNode) {
        Preconditions.checkState(classDefNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF}));
        ArrayList<AstNode> fields = new ArrayList<AstNode>();
        for (AstNode directive : classDefNode.getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK}).getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getChildren()) {
            AstNode fieldDef = Clazz.getFieldDefinition(directive);
            if (fieldDef == null) continue;
            fields.add(fieldDef);
        }
        return fields;
    }

    public static String getName(AstNode classDefNode) {
        Preconditions.checkState(classDefNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF}));
        return classDefNode.getFirstChild(new AstNodeType[]{FlexGrammar.CLASS_NAME}).getFirstChild(new AstNodeType[]{FlexGrammar.CLASS_IDENTIFIERS}).getLastChild().getTokenValue();
    }

    public static AstNode getConstructor(AstNode classDefNode) {
        Preconditions.checkState(classDefNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF}));
        String className = Clazz.getName(classDefNode);
        for (AstNode directive : classDefNode.getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK}).getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getChildren()) {
            AstNode functionDef = Clazz.getFunctionDefinition(directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}));
            if (functionDef == null || !Function.isConstructor(functionDef, className)) continue;
            return functionDef;
        }
        return null;
    }

    private static AstNode getFieldDefinition(AstNode directive) {
        Preconditions.checkState(directive.is(new AstNodeType[]{FlexGrammar.DIRECTIVE}));
        AstNode annotableDir = directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE});
        return annotableDir == null ? null : annotableDir.getFirstChild(new AstNodeType[]{FlexGrammar.VARIABLE_DECLARATION_STATEMENT});
    }

    private static AstNode getFunctionDefinition(@Nullable AstNode annotableDir) {
        return annotableDir != null && annotableDir.is(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}) && annotableDir.getFirstChild().is(new AstNodeType[]{FlexGrammar.FUNCTION_DEF}) ? annotableDir.getFirstChild() : null;
    }

    public static List<AstNode> getFunctions(AstNode classDefNode) {
        Preconditions.checkState(classDefNode.is(new AstNodeType[]{FlexGrammar.CLASS_DEF}));
        ArrayList<AstNode> functions = new ArrayList<AstNode>();
        for (AstNode directive : classDefNode.getFirstChild(new AstNodeType[]{FlexGrammar.BLOCK}).getFirstChild(new AstNodeType[]{FlexGrammar.DIRECTIVES}).getChildren()) {
            AstNode functionDef = Clazz.getFunctionDefinition(directive.getFirstChild(new AstNodeType[]{FlexGrammar.ANNOTABLE_DIRECTIVE}));
            if (functionDef == null) continue;
            functions.add(functionDef);
        }
        return functions;
    }
}

