/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;

@Rule(key="S1451")
public class FileHeaderCheck
extends FlexCheck {
    private static final String DEFAULT_HEADER_FORMAT = "";
    @RuleProperty(key="headerFormat", description="Expected copyright and license header", defaultValue="", type="TEXT")
    public String headerFormat = "";
    @RuleProperty(key="isRegularExpression", description="Whether the headerFormat is a regular expression", defaultValue="false")
    public boolean isRegularExpression = false;
    private Predicate<String> headerMatcher;

    public Predicate<String> headerMatcher() {
        if (this.headerMatcher == null) {
            if (this.isRegularExpression) {
                String regexp = this.headerFormat;
                if (!this.headerFormat.endsWith("\n") && !this.headerFormat.endsWith("\r")) {
                    regexp = regexp + "(\r|\r\n|\n)";
                }
                Pattern pattern = Pattern.compile(regexp);
                this.headerMatcher = s -> FileHeaderCheck.matchesRegularExpression(pattern, s);
            } else {
                String[] expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
                this.headerMatcher = s -> FileHeaderCheck.matchesPlainTextHeader(expectedLines, s);
            }
        }
        return this.headerMatcher;
    }

    public List<AstNodeType> subscribedTo() {
        return Collections.emptyList();
    }

    public void visitFile(@Nullable AstNode astNode) {
        String fileContent = this.getContext().fileContent();
        boolean hasHeader = this.headerMatcher().test(fileContent);
        if (!hasHeader) {
            this.addFileIssue("Add or update the header of this file.");
        }
    }

    private static boolean matchesRegularExpression(Pattern regularExpression, String content) {
        Matcher matcher = regularExpression.matcher(content);
        if (matcher.find()) {
            return matcher.start() == 0;
        }
        return false;
    }

    private static boolean matchesPlainTextHeader(String[] expectedLines, String content) {
        boolean result;
        String[] lines = content.split("\\r?\\n");
        if (expectedLines.length <= lines.length) {
            result = true;
            for (int i = 0; i < expectedLines.length; ++i) {
                String line = lines[i];
                if (line.equals(expectedLines[i])) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }
}

