/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks.utils;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.FlexKeyword;

public final class Modifiers {
    private Modifiers() {
    }

    public static Set<AstNodeType> getModifiers(@Nullable AstNode attributes) {
        HashSet<AstNodeType> modifiersSet = new HashSet<AstNodeType>();
        if (attributes != null && attributes.is(new AstNodeType[]{FlexGrammar.ATTRIBUTES})) {
            for (AstNode attribute : attributes.getChildren(new AstNodeType[]{FlexGrammar.ATTRIBUTE})) {
                if (attribute.getFirstChild().is(new AstNodeType[]{FlexGrammar.RESERVED_NAMESPACE})) {
                    modifiersSet.add(attribute.getFirstChild(new AstNodeType[]{FlexGrammar.RESERVED_NAMESPACE}).getFirstChild().getType());
                    continue;
                }
                if (!attribute.getFirstChild().is(new AstNodeType[]{FlexGrammar.ATTRIBUTE_EXPR}) || attribute.getFirstChild().getNumberOfChildren() != 1) continue;
                modifiersSet.add(attribute.getFirstChild().getFirstChild(new AstNodeType[]{FlexGrammar.IDENTIFIER}).getFirstChild().getType());
            }
        }
        return modifiersSet;
    }

    public static boolean isNonPublic(Set<AstNodeType> modifiers) {
        for (AstNodeType modifier : modifiers) {
            if (!modifier.equals(FlexKeyword.INTERNAL) && !modifier.equals(FlexKeyword.PROTECTED) && !modifier.equals(FlexKeyword.PRIVATE)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublic(AstNode attriutes) {
        Set<AstNodeType> modifiers = Modifiers.getModifiers(attriutes);
        return modifiers.contains(FlexKeyword.PUBLIC) || !Modifiers.isNonPublic(modifiers);
    }
}

