/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.checks.utils.Clazz;
import org.sonar.flex.checks.utils.Modifiers;

@Rule(key="S1448")
public class ClassWithTooManyFunctionsCheck
extends FlexCheck {
    private static final int DEFAULT_MAX = 20;
    private static final boolean DEFAULT_INCLUDE_NON_PUBLIC = true;
    @RuleProperty(key="maximumFunctionThreshold", description="The maximum number of methods", defaultValue="20")
    int maximumFunctionThreshold = 20;
    @RuleProperty(key="countNonpublicMethods", description="Whether or not to include non-public methods in the count", defaultValue="true", type="BOOLEAN")
    boolean countNonpublicMethods = true;

    public List<AstNodeType> subscribedTo() {
        return Collections.singletonList(FlexGrammar.CLASS_DEF);
    }

    public void visitNode(AstNode astNode) {
        int nbMethods = this.getNumberOfMethods(astNode);
        if (nbMethods > this.maximumFunctionThreshold) {
            String message = MessageFormat.format("Class \"{0}\" has {1} methods, which is greater than {2} authorized. Split it into smaller classes.", Clazz.getName(astNode), nbMethods, this.maximumFunctionThreshold);
            this.addIssue(message, astNode);
        }
    }

    private int getNumberOfMethods(AstNode classNode) {
        List<AstNode> methods = Clazz.getFunctions(classNode);
        int nbMethods = methods.size();
        if (!this.countNonpublicMethods) {
            nbMethods -= ClassWithTooManyFunctionsCheck.getNumberOfNonPublicMethods(methods);
        }
        return nbMethods;
    }

    private static int getNumberOfNonPublicMethods(List<AstNode> methods) {
        int nbNonPublicMethod = 0;
        for (AstNode method : methods) {
            if (!Modifiers.isNonPublic(Modifiers.getModifiers(method.getPreviousAstNode()))) continue;
            ++nbNonPublicMethod;
        }
        return nbNonPublicMethod;
    }
}

