/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.flex.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.flex.FlexCheck;
import org.sonar.flex.FlexGrammar;
import org.sonar.flex.metrics.FileLinesVisitor;

@Rule(key="S138")
public class TooManyLinesInFunctionCheck
extends FlexCheck {
    private static final int DEFAULT = 100;
    @RuleProperty(key="max", description="Maximum authorized lines in a function", defaultValue="100")
    int max = 100;

    public List<AstNodeType> subscribedTo() {
        return Arrays.asList(FlexGrammar.FUNCTION_DEF, FlexGrammar.FUNCTION_EXPR);
    }

    public void visitNode(AstNode astNode) {
        FileLinesVisitor linesVisitor = new FileLinesVisitor();
        linesVisitor.scanNode(astNode);
        int nbLines = linesVisitor.linesOfCode().size();
        if (nbLines > this.max) {
            this.addIssue(MessageFormat.format("This function has {0} lines of code, which is greater than the {1} lines authorized. Split it into smaller functions.", nbLines, this.max), astNode);
        }
    }
}

