/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.slang.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.sonarsource.analyzer.commons.TokenLocation;
import org.sonarsource.slang.api.ASTConverter;
import org.sonarsource.slang.api.AssignmentExpressionTree;
import org.sonarsource.slang.api.BinaryExpressionTree;
import org.sonarsource.slang.api.BlockTree;
import org.sonarsource.slang.api.CatchTree;
import org.sonarsource.slang.api.Comment;
import org.sonarsource.slang.api.IdentifierTree;
import org.sonarsource.slang.api.JumpTree;
import org.sonarsource.slang.api.LoopTree;
import org.sonarsource.slang.api.MatchCaseTree;
import org.sonarsource.slang.api.ModifierTree;
import org.sonarsource.slang.api.NativeKind;
import org.sonarsource.slang.api.NativeTree;
import org.sonarsource.slang.api.ParameterTree;
import org.sonarsource.slang.api.TextPointer;
import org.sonarsource.slang.api.TextRange;
import org.sonarsource.slang.api.Token;
import org.sonarsource.slang.api.Tree;
import org.sonarsource.slang.api.TreeMetaData;
import org.sonarsource.slang.api.UnaryExpressionTree;
import org.sonarsource.slang.impl.AssignmentExpressionTreeImpl;
import org.sonarsource.slang.impl.BinaryExpressionTreeImpl;
import org.sonarsource.slang.impl.BlockTreeImpl;
import org.sonarsource.slang.impl.CatchTreeImpl;
import org.sonarsource.slang.impl.ClassDeclarationTreeImpl;
import org.sonarsource.slang.impl.CommentImpl;
import org.sonarsource.slang.impl.ExceptionHandlingTreeImpl;
import org.sonarsource.slang.impl.FunctionDeclarationTreeImpl;
import org.sonarsource.slang.impl.IdentifierTreeImpl;
import org.sonarsource.slang.impl.IfTreeImpl;
import org.sonarsource.slang.impl.JumpTreeImpl;
import org.sonarsource.slang.impl.LiteralTreeImpl;
import org.sonarsource.slang.impl.LoopTreeImpl;
import org.sonarsource.slang.impl.MatchCaseTreeImpl;
import org.sonarsource.slang.impl.MatchTreeImpl;
import org.sonarsource.slang.impl.ModifierTreeImpl;
import org.sonarsource.slang.impl.NativeTreeImpl;
import org.sonarsource.slang.impl.ParameterTreeImpl;
import org.sonarsource.slang.impl.ParenthesizedExpressionTreeImpl;
import org.sonarsource.slang.impl.ReturnTreeImpl;
import org.sonarsource.slang.impl.StringLiteralTreeImpl;
import org.sonarsource.slang.impl.TextPointerImpl;
import org.sonarsource.slang.impl.TextRangeImpl;
import org.sonarsource.slang.impl.TextRanges;
import org.sonarsource.slang.impl.TokenImpl;
import org.sonarsource.slang.impl.TopLevelTreeImpl;
import org.sonarsource.slang.impl.TreeMetaDataProvider;
import org.sonarsource.slang.impl.UnaryExpressionTreeImpl;
import org.sonarsource.slang.impl.VariableDeclarationTreeImpl;
import org.sonarsource.slang.parser.ErrorStrategy;
import org.sonarsource.slang.parser.SLangBaseVisitor;
import org.sonarsource.slang.parser.SLangLexer;
import org.sonarsource.slang.parser.SLangParser;
import org.sonarsource.slang.parser.SNativeKind;

public class SLangConverter
implements ASTConverter {
    private static final Set<Integer> KEYWORD_TOKEN_TYPES = new HashSet<Integer>(Arrays.asList(21, 24, 25, 26, 27, 28, 29, 30, 31));
    private static final Map<String, BinaryExpressionTree.Operator> BINARY_OPERATOR_MAP = SLangConverter.binaryOperatorMap();
    private static final Map<String, AssignmentExpressionTree.Operator> ASSIGNMENT_OPERATOR_MAP = SLangConverter.assignmentOperatorMap();

    public Tree parse(String slangCode) {
        SLangLexer lexer = new SLangLexer((CharStream)CharStreams.fromString((String)slangCode));
        ArrayList<Comment> comments = new ArrayList<Comment>();
        CommonTokenStream antlrTokens = new CommonTokenStream((TokenSource)lexer);
        antlrTokens.fill();
        ArrayList<org.sonarsource.slang.api.Token> tokens = new ArrayList<org.sonarsource.slang.api.Token>();
        for (int index = 0; index < antlrTokens.size(); ++index) {
            Token token = antlrTokens.get(index);
            TextRange textRange = SLangConverter.getSlangTextRange(token);
            if (token.getChannel() == 1) {
                comments.add((Comment)SLangConverter.comment(token, textRange));
                continue;
            }
            Token.Type type = Token.Type.OTHER;
            if (KEYWORD_TOKEN_TYPES.contains(token.getType())) {
                type = Token.Type.KEYWORD;
            } else if (token.getType() == 41) {
                type = Token.Type.STRING_LITERAL;
            }
            tokens.add((org.sonarsource.slang.api.Token)new TokenImpl(textRange, token.getText(), type));
        }
        SLangParser parser = new SLangParser((TokenStream)antlrTokens);
        parser.setErrorHandler((ANTLRErrorStrategy)new ErrorStrategy());
        SLangParseTreeVisitor slangVisitor = new SLangParseTreeVisitor(comments, tokens);
        return (Tree)slangVisitor.visit((ParseTree)parser.slangFile());
    }

    private static CommentImpl comment(Token token, TextRange range) {
        TextPointer contentEnd;
        String contentText;
        String text = token.getText();
        if (text.startsWith("//")) {
            contentText = text.substring(2);
            contentEnd = range.end();
        } else {
            contentText = text.substring(2, text.length() - 2);
            contentEnd = new TextPointerImpl(range.end().line(), range.end().lineOffset() - 2);
        }
        TextPointerImpl contentStart = new TextPointerImpl(range.start().line(), range.start().lineOffset() + 2);
        return new CommentImpl(token.getText(), contentText, range, (TextRange)new TextRangeImpl((TextPointer)contentStart, contentEnd));
    }

    private static Map<String, BinaryExpressionTree.Operator> binaryOperatorMap() {
        HashMap<String, BinaryExpressionTree.Operator> map = new HashMap<String, BinaryExpressionTree.Operator>();
        map.put("&&", BinaryExpressionTree.Operator.CONDITIONAL_AND);
        map.put("||", BinaryExpressionTree.Operator.CONDITIONAL_OR);
        map.put(">", BinaryExpressionTree.Operator.GREATER_THAN);
        map.put(">=", BinaryExpressionTree.Operator.GREATER_THAN_OR_EQUAL_TO);
        map.put("<", BinaryExpressionTree.Operator.LESS_THAN);
        map.put("<=", BinaryExpressionTree.Operator.LESS_THAN_OR_EQUAL_TO);
        map.put("==", BinaryExpressionTree.Operator.EQUAL_TO);
        map.put("!=", BinaryExpressionTree.Operator.NOT_EQUAL_TO);
        map.put("+", BinaryExpressionTree.Operator.PLUS);
        map.put("-", BinaryExpressionTree.Operator.MINUS);
        map.put("*", BinaryExpressionTree.Operator.TIMES);
        map.put("/", BinaryExpressionTree.Operator.DIVIDED_BY);
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, AssignmentExpressionTree.Operator> assignmentOperatorMap() {
        HashMap<String, AssignmentExpressionTree.Operator> map = new HashMap<String, AssignmentExpressionTree.Operator>();
        map.put("=", AssignmentExpressionTree.Operator.EQUAL);
        map.put("+=", AssignmentExpressionTree.Operator.PLUS_EQUAL);
        map.put("-=", AssignmentExpressionTree.Operator.MINUS_EQUAL);
        map.put("*=", AssignmentExpressionTree.Operator.TIMES_EQUAL);
        map.put("%=", AssignmentExpressionTree.Operator.MODULO_EQUAL);
        return Collections.unmodifiableMap(map);
    }

    private static TextRange getSlangTextRange(Token matchToken) {
        TokenLocation location = new TokenLocation(matchToken.getLine(), matchToken.getCharPositionInLine(), matchToken.getText());
        return new TextRangeImpl(location.startLine(), location.startLineOffset(), location.endLine(), location.endLineOffset());
    }

    private static class SLangParseTreeVisitor
    extends SLangBaseVisitor<Tree> {
        private final TreeMetaDataProvider metaDataProvider;

        public SLangParseTreeVisitor(List<Comment> comments, List<org.sonarsource.slang.api.Token> tokens) {
            this.metaDataProvider = new TreeMetaDataProvider(comments, tokens);
        }

        @Override
        public Tree visitSlangFile(SLangParser.SlangFileContext ctx) {
            TextRangeImpl textRange = new TextRangeImpl(SLangParseTreeVisitor.startOf(ctx.start), (TextPointer)new TextPointerImpl(ctx.stop.getLine(), ctx.stop.getCharPositionInLine()));
            return new TopLevelTreeImpl(this.meta((TextRange)textRange), this.list(ctx.typeDeclaration()), this.metaDataProvider.allComments());
        }

        @Override
        public Tree visitTypeDeclaration(SLangParser.TypeDeclarationContext ctx) {
            if (ctx.methodDeclaration() != null) {
                return (Tree)this.visit((ParseTree)ctx.methodDeclaration());
            }
            if (ctx.classDeclaration() != null) {
                return (Tree)this.visit((ParseTree)ctx.classDeclaration());
            }
            return (Tree)this.visit((ParseTree)ctx.statement());
        }

        @Override
        public Tree visitClassDeclaration(SLangParser.ClassDeclarationContext ctx) {
            ArrayList<Object> children = new ArrayList<Object>();
            IdentifierTree identifier = null;
            if (ctx.identifier() != null) {
                identifier = (IdentifierTree)this.visit((ParseTree)ctx.identifier());
                children.add(identifier);
            }
            children.addAll(this.list(ctx.typeDeclaration()));
            NativeTreeImpl classDecl = new NativeTreeImpl(this.meta(ctx), (NativeKind)new SNativeKind(ctx), children);
            return new ClassDeclarationTreeImpl(this.meta(ctx), identifier, (Tree)classDecl);
        }

        @Override
        public Tree visitNativeExpression(SLangParser.NativeExpressionContext ctx) {
            return this.nativeTree(ctx, ctx.nativeBlock());
        }

        @Override
        public Tree visitParenthesizedExpression(SLangParser.ParenthesizedExpressionContext ctx) {
            return new ParenthesizedExpressionTreeImpl(this.meta(ctx), (Tree)this.visit((ParseTree)ctx.statement()), SLangParseTreeVisitor.toSlangToken(ctx.LPAREN().getSymbol()), SLangParseTreeVisitor.toSlangToken(ctx.RPAREN().getSymbol()));
        }

        @Override
        public Tree visitMethodDeclaration(SLangParser.MethodDeclarationContext ctx) {
            List<Tree> modifiers = this.list(ctx.methodModifier());
            IdentifierTreeImpl returnType = null;
            IdentifierTree name = null;
            SLangParser.MethodHeaderContext methodHeaderContext = ctx.methodHeader();
            SLangParser.SimpleTypeContext resultContext = methodHeaderContext.simpleType();
            SLangParser.IdentifierContext identifier = methodHeaderContext.methodDeclarator().identifier();
            if (resultContext != null) {
                returnType = new IdentifierTreeImpl(this.meta(resultContext), resultContext.getText());
            }
            if (identifier != null) {
                name = (IdentifierTree)this.visit((ParseTree)identifier);
            }
            ArrayList<Object> convertedParameters = new ArrayList<Object>();
            SLangParser.FormalParameterListContext formalParameterListContext = methodHeaderContext.methodDeclarator().formalParameterList();
            if (formalParameterListContext != null) {
                SLangParser.FormalParametersContext formalParameters = formalParameterListContext.formalParameters();
                if (formalParameters != null) {
                    convertedParameters.addAll(this.list(formalParameters.formalParameter()));
                }
                convertedParameters.add(this.visit((ParseTree)formalParameterListContext.lastFormalParameter()));
            }
            return new FunctionDeclarationTreeImpl(this.meta(ctx), modifiers, (Tree)returnType, name, convertedParameters, (BlockTree)this.visit((ParseTree)ctx.methodBody()), Collections.emptyList());
        }

        @Override
        public Tree visitMethodModifier(SLangParser.MethodModifierContext ctx) {
            ModifierTree.Kind modifierKind = ModifierTree.Kind.PUBLIC;
            if (ctx.PRIVATE() != null) {
                modifierKind = ModifierTree.Kind.PRIVATE;
            }
            return new ModifierTreeImpl(this.meta(ctx), modifierKind);
        }

        @Override
        public Tree visitMethodInvocation(SLangParser.MethodInvocationContext ctx) {
            SLangParser.ArgumentListContext argumentListContext = ctx.argumentList();
            ArrayList<Object> children = new ArrayList<Object>();
            children.add(this.visit((ParseTree)ctx.methodName()));
            if (argumentListContext != null) {
                children.addAll(this.list(argumentListContext.statement()));
            }
            return new NativeTreeImpl(this.meta(ctx), (NativeKind)new SNativeKind(ctx), children);
        }

        @Override
        public Tree visitMethodBody(SLangParser.MethodBodyContext ctx) {
            if (ctx.SEMICOLON() != null) {
                return null;
            }
            return (Tree)this.visit((ParseTree)ctx.block());
        }

        @Override
        public Tree visitFormalParameter(SLangParser.FormalParameterContext ctx) {
            IdentifierTree tree = (IdentifierTree)this.visit((ParseTree)ctx.variableDeclaratorId().identifier());
            IdentifierTreeImpl type = null;
            if (ctx.simpleType() != null) {
                type = new IdentifierTreeImpl(this.meta(ctx.simpleType()), ctx.simpleType().getText());
            }
            return new ParameterTreeImpl(this.meta(ctx), tree, type);
        }

        @Override
        public Tree visitLastFormalParameter(SLangParser.LastFormalParameterContext ctx) {
            return (Tree)this.visit((ParseTree)ctx.formalParameter());
        }

        @Override
        public Tree visitDeclaration(SLangParser.DeclarationContext ctx) {
            IdentifierTree identifier = (IdentifierTree)this.visit((ParseTree)ctx.identifier());
            IdentifierTreeImpl type = null;
            if (ctx.simpleType() != null) {
                type = new IdentifierTreeImpl(this.meta(ctx.simpleType()), ctx.simpleType().getText());
            }
            Tree initializer = null;
            if (ctx.expression() != null) {
                initializer = (Tree)this.visit((ParseTree)ctx.expression());
            }
            boolean isVal = ctx.declarationModifier().VAL() != null;
            return new VariableDeclarationTreeImpl(this.meta(ctx), identifier, (Tree)type, initializer, isVal);
        }

        @Override
        public Tree visitBlock(SLangParser.BlockContext ctx) {
            return new BlockTreeImpl(this.meta(ctx), this.list(ctx.statement()));
        }

        @Override
        public Tree visitIfExpression(SLangParser.IfExpressionContext ctx) {
            org.sonarsource.slang.api.Token ifToken = SLangParseTreeVisitor.toSlangToken(ctx.IF().getSymbol());
            org.sonarsource.slang.api.Token elseToken = null;
            Tree elseBranch = null;
            if (ctx.controlBlock().size() > 1) {
                elseBranch = (Tree)this.visit((ParseTree)ctx.controlBlock(1));
                elseToken = SLangParseTreeVisitor.toSlangToken(ctx.ELSE().getSymbol());
            }
            Tree thenBranch = (Tree)this.visit((ParseTree)ctx.controlBlock(0));
            return new IfTreeImpl(this.meta(ctx), (Tree)this.visit((ParseTree)ctx.statement()), thenBranch, elseBranch, ifToken, elseToken);
        }

        @Override
        public Tree visitMatchExpression(SLangParser.MatchExpressionContext ctx) {
            ArrayList<MatchCaseTree> cases = new ArrayList<MatchCaseTree>();
            for (SLangParser.MatchCaseContext matchCaseContext : ctx.matchCase()) {
                cases.add((MatchCaseTree)this.visit((ParseTree)matchCaseContext));
            }
            TreeMetaData meta = this.meta(ctx);
            return new MatchTreeImpl(meta, (Tree)this.visit((ParseTree)ctx.statement()), cases, SLangParseTreeVisitor.toSlangToken(ctx.MATCH().getSymbol()));
        }

        @Override
        public Tree visitMatchCase(SLangParser.MatchCaseContext ctx) {
            Tree expression = ctx.statement() == null ? null : (Tree)this.visit((ParseTree)ctx.statement());
            Tree body = (Tree)this.visit((ParseTree)ctx.controlBlock());
            return new MatchCaseTreeImpl(this.meta(ctx), expression, body);
        }

        @Override
        public Tree visitForLoop(SLangParser.ForLoopContext ctx) {
            Tree condition = (Tree)this.visit((ParseTree)ctx.declaration());
            Tree body = (Tree)this.visit((ParseTree)ctx.controlBlock());
            return new LoopTreeImpl(this.meta(ctx), condition, body, LoopTree.LoopKind.FOR, SLangParseTreeVisitor.toSlangToken(ctx.FOR().getSymbol()));
        }

        @Override
        public Tree visitWhileLoop(SLangParser.WhileLoopContext ctx) {
            Tree condition = (Tree)this.visit((ParseTree)ctx.statement());
            Tree body = (Tree)this.visit((ParseTree)ctx.controlBlock());
            return new LoopTreeImpl(this.meta(ctx), condition, body, LoopTree.LoopKind.WHILE, SLangParseTreeVisitor.toSlangToken(ctx.WHILE().getSymbol()));
        }

        @Override
        public Tree visitDoWhileLoop(SLangParser.DoWhileLoopContext ctx) {
            Tree condition = (Tree)this.visit((ParseTree)ctx.statement());
            Tree body = (Tree)this.visit((ParseTree)ctx.controlBlock());
            return new LoopTreeImpl(this.meta(ctx), condition, body, LoopTree.LoopKind.DOWHILE, SLangParseTreeVisitor.toSlangToken(ctx.DO().getSymbol()));
        }

        @Override
        public Tree visitCatchBlock(SLangParser.CatchBlockContext ctx) {
            ParameterTree parameter = ctx.formalParameter() == null ? null : (ParameterTree)this.visit((ParseTree)ctx.formalParameter());
            Tree body = (Tree)this.visit((ParseTree)ctx.block());
            return new CatchTreeImpl(this.meta(ctx), (Tree)parameter, body, SLangParseTreeVisitor.toSlangToken(ctx.CATCH().getSymbol()));
        }

        @Override
        public Tree visitTryExpression(SLangParser.TryExpressionContext ctx) {
            Tree tryBlock = (Tree)this.visit((ParseTree)ctx.block());
            ArrayList<CatchTree> catchTreeList = new ArrayList<CatchTree>();
            for (SLangParser.CatchBlockContext catchBlockContext : ctx.catchBlock()) {
                catchTreeList.add((CatchTree)this.visit((ParseTree)catchBlockContext));
            }
            org.sonarsource.slang.api.Token tryToken = SLangParseTreeVisitor.toSlangToken(ctx.TRY().getSymbol());
            Tree finallyBlock = ctx.finallyBlock() == null ? null : (Tree)this.visit((ParseTree)ctx.finallyBlock());
            return new ExceptionHandlingTreeImpl(this.meta(ctx), tryBlock, tryToken, catchTreeList, finallyBlock);
        }

        @Override
        public Tree visitNativeBlock(SLangParser.NativeBlockContext ctx) {
            return this.nativeTree(ctx, ctx.statement());
        }

        @Override
        public Tree visitAssignment(SLangParser.AssignmentContext ctx) {
            Tree leftHandSide = (Tree)this.visit((ParseTree)ctx.expression());
            Tree statementOrExpression = this.assignmentTree(ctx.statement(), ctx.assignmentOperator());
            AssignmentExpressionTree.Operator operator = (AssignmentExpressionTree.Operator)ASSIGNMENT_OPERATOR_MAP.get(ctx.assignmentOperator(0).getText());
            return new AssignmentExpressionTreeImpl(this.meta(ctx), operator, leftHandSide, statementOrExpression);
        }

        @Override
        public Tree visitDisjunction(SLangParser.DisjunctionContext ctx) {
            return this.binaryTree(ctx.conjunction(), ctx.disjunctionOperator());
        }

        @Override
        public Tree visitConjunction(SLangParser.ConjunctionContext ctx) {
            return this.binaryTree(ctx.equalityComparison(), ctx.conjunctionOperator());
        }

        @Override
        public Tree visitEqualityComparison(SLangParser.EqualityComparisonContext ctx) {
            return this.binaryTree(ctx.comparison(), ctx.equalityOperator());
        }

        @Override
        public Tree visitComparison(SLangParser.ComparisonContext ctx) {
            return this.binaryTree(ctx.additiveExpression(), ctx.comparisonOperator());
        }

        @Override
        public Tree visitAdditiveExpression(SLangParser.AdditiveExpressionContext ctx) {
            return this.binaryTree(ctx.multiplicativeExpression(), ctx.additiveOperator());
        }

        @Override
        public Tree visitMultiplicativeExpression(SLangParser.MultiplicativeExpressionContext ctx) {
            return this.binaryTree(ctx.unaryExpression(), ctx.multiplicativeOperator());
        }

        @Override
        public Tree visitUnaryExpression(SLangParser.UnaryExpressionContext ctx) {
            if (ctx.unaryOperator() == null) {
                return (Tree)this.visit((ParseTree)ctx.atomicExpression());
            }
            Tree operand = (Tree)this.visit((ParseTree)ctx.unaryExpression());
            return new UnaryExpressionTreeImpl(this.meta(ctx), UnaryExpressionTree.Operator.NEGATE, operand);
        }

        @Override
        public Tree visitLiteral(SLangParser.LiteralContext ctx) {
            if (ctx.StringLiteral() != null) {
                return new StringLiteralTreeImpl(this.meta(ctx), ctx.getText());
            }
            return new LiteralTreeImpl(this.meta(ctx), ctx.getText());
        }

        @Override
        public Tree visitIdentifier(SLangParser.IdentifierContext ctx) {
            return new IdentifierTreeImpl(this.meta(ctx), ctx.getText());
        }

        @Override
        public Tree visitBreakExpression(SLangParser.BreakExpressionContext ctx) {
            IdentifierTree label = null;
            if (ctx.label() != null) {
                label = (IdentifierTree)this.visit((ParseTree)ctx.label());
            }
            return new JumpTreeImpl(this.meta(ctx), SLangParseTreeVisitor.toSlangToken(ctx.BREAK().getSymbol()), JumpTree.JumpKind.BREAK, label);
        }

        @Override
        public Tree visitContinueExpression(SLangParser.ContinueExpressionContext ctx) {
            IdentifierTree label = null;
            if (ctx.label() != null) {
                label = (IdentifierTree)this.visit((ParseTree)ctx.label());
            }
            return new JumpTreeImpl(this.meta(ctx), SLangParseTreeVisitor.toSlangToken(ctx.CONTINUE().getSymbol()), JumpTree.JumpKind.CONTINUE, label);
        }

        @Override
        public Tree visitReturnExpression(SLangParser.ReturnExpressionContext ctx) {
            Tree returnBody = null;
            if (ctx.statement() != null) {
                returnBody = (Tree)this.visit((ParseTree)ctx.statement());
            }
            return new ReturnTreeImpl(this.meta(ctx), SLangParseTreeVisitor.toSlangToken(ctx.RETURN().getSymbol()), returnBody);
        }

        private static TextPointer startOf(Token token) {
            return new TextPointerImpl(token.getLine(), token.getCharPositionInLine());
        }

        private static TextPointer endOf(Token token) {
            return new TextPointerImpl(token.getLine(), token.getCharPositionInLine() + token.getText().length());
        }

        private TreeMetaData meta(ParserRuleContext ctx) {
            return this.meta((TextRange)new TextRangeImpl(SLangParseTreeVisitor.startOf(ctx.start), SLangParseTreeVisitor.endOf(ctx.stop)));
        }

        private TreeMetaData meta(Tree first, Tree last) {
            return this.meta((TextRange)new TextRangeImpl(first.metaData().textRange().start(), last.metaData().textRange().end()));
        }

        private TreeMetaData meta(TextRange textRange) {
            return this.metaDataProvider.metaData(textRange);
        }

        private NativeTree nativeTree(ParserRuleContext ctx, List<? extends ParseTree> rawChildren) {
            List<Tree> children = this.list(rawChildren);
            return new NativeTreeImpl(this.meta(ctx), (NativeKind)new SNativeKind(ctx), children);
        }

        private List<Tree> list(List<? extends ParseTree> rawChildren) {
            return rawChildren.stream().map(arg_0 -> ((SLangParseTreeVisitor)this).visit(arg_0)).collect(Collectors.toList());
        }

        private Tree binaryTree(List<? extends ParseTree> operands, List<? extends ParserRuleContext> operators) {
            Tree result = (Tree)this.visit(operands.get(operands.size() - 1));
            for (int i = operands.size() - 2; i >= 0; --i) {
                Tree left = (Tree)this.visit(operands.get(i));
                BinaryExpressionTree.Operator operator = (BinaryExpressionTree.Operator)BINARY_OPERATOR_MAP.get(operators.get(i).getText());
                result = new BinaryExpressionTreeImpl(this.meta(left, result), operator, SLangParseTreeVisitor.operatorToken(operators.get(i)), left, result);
            }
            return result;
        }

        private Tree assignmentTree(List<? extends ParseTree> expressions, List<? extends ParseTree> operators) {
            Tree result = (Tree)this.visit(expressions.get(expressions.size() - 1));
            for (int i = expressions.size() - 2; i >= 0; --i) {
                Tree left = (Tree)this.visit(expressions.get(i));
                AssignmentExpressionTree.Operator operator = (AssignmentExpressionTree.Operator)ASSIGNMENT_OPERATOR_MAP.get(operators.get(i).getText());
                result = new AssignmentExpressionTreeImpl(this.meta(left, result), operator, left, result);
            }
            return result;
        }

        private static org.sonarsource.slang.api.Token toSlangToken(Token antlrToken) {
            TextRange textRange = SLangConverter.getSlangTextRange(antlrToken);
            return new TokenImpl(textRange, antlrToken.getText(), Token.Type.KEYWORD);
        }

        private static org.sonarsource.slang.api.Token operatorToken(ParserRuleContext parserRuleContext) {
            TextRange textRange = TextRanges.merge(Arrays.asList(SLangConverter.getSlangTextRange(parserRuleContext.start), SLangConverter.getSlangTextRange(parserRuleContext.stop)));
            return new TokenImpl(textRange, parserRuleContext.getText(), Token.Type.OTHER);
        }
    }
}

